/*
 * Decompiled with CFR 0.152.
 */
package cn.myafx.cache.base;

import cn.myafx.cache.ICacheCursor;
import cn.myafx.cache.ICacheKey;
import cn.myafx.cache.base.IHashCache;
import cn.myafx.cache.base.RedisCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;

public class HashCache<TField, TValue>
extends RedisCache
implements IHashCache<TField, TValue> {
    private Class<TField> fieldClass;
    private Class<TValue> valueClass;

    public HashCache(String node, String item, RedisConnection redisConnection, ICacheKey cacheKey, String prefix, Class<TField> fieldClass, Class<TValue> valueClass) throws Exception {
        super(node, item, redisConnection, cacheKey, prefix);
        if (fieldClass == null) {
            throw new Exception("fieldClass is null!");
        }
        if (valueClass == null) {
            throw new Exception("valueClass is null!");
        }
        this.fieldClass = fieldClass;
        this.valueClass = valueClass;
    }

    @Override
    public boolean set(TField field, TValue value, Object ... args) throws Exception {
        if (field == null) {
            throw new Exception("field is null!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cachekeyBytes = this.getBytes(cachekey);
        Boolean r = this.redis.hashCommands().hSet(cachekeyBytes, this.serialize(field), this.serialize(value));
        return r != null;
    }

    @Override
    public void addOrUpdate(Map<TField, TValue> map, Object ... args) throws Exception {
        if (map == null) {
            throw new Exception("map is null!");
        }
        HashMap<byte[], byte[]> hmap = new HashMap<byte[], byte[]>(map.size());
        ArrayList<byte[]> dels = new ArrayList<byte[]>();
        for (Map.Entry<TField, TValue> h : map.entrySet()) {
            if (h.getKey() == null) {
                throw new Exception("map.key is null!");
            }
            if (h.getValue() == null) {
                dels.add(this.serialize(h.getKey()));
                continue;
            }
            hmap.put(this.serialize(h.getValue()), this.serialize(h.getValue()));
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cachekeyBytes = this.getBytes(cachekey);
        this.redis.hashCommands().hMSet(cachekeyBytes, hmap);
        if (dels.size() > 0) {
            byte[][] delarr = new byte[dels.size()][];
            for (int i = 0; i < dels.size(); ++i) {
                delarr[i] = (byte[])dels.get(i);
            }
            this.redis.hashCommands().hDel(cachekeyBytes, (byte[][])delarr);
        }
    }

    @Override
    public Map<TField, TValue> get(Object ... args) throws Exception {
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cachekeyBytes = this.getBytes(cachekey);
        Map rmap = this.redis.hashCommands().hGetAll(cachekeyBytes);
        HashMap<TField, TValue> map = null;
        if (rmap != null) {
            map = new HashMap<TField, TValue>(rmap.size());
            for (Map.Entry hm : rmap.entrySet()) {
                map.put(this.deserialize((byte[])hm.getKey(), this.fieldClass), this.deserialize((byte[])hm.getValue(), this.valueClass));
            }
        }
        return map;
    }

    @Override
    public TValue getValue(TField field, Object ... args) throws Exception {
        if (field == null) {
            throw new Exception("field is null!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cachekeyBytes = this.getBytes(cachekey);
        byte[] r = this.redis.hashCommands().hGet(cachekeyBytes, this.serialize(field));
        TValue v = this.deserialize(r, this.valueClass);
        return v;
    }

    @Override
    public List<TValue> getValue(List<TField> fields, Object ... args) throws Exception {
        if (fields == null) {
            throw new Exception("fields is null!");
        }
        if (fields.size() == 0) {
            return new ArrayList(0);
        }
        byte[][] karr = new byte[fields.size()][];
        for (int i = 0; i < fields.size(); ++i) {
            TField k = fields.get(i);
            if (k == null) {
                throw new Exception("fields item is null!");
            }
            karr[i] = this.serialize(k);
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cachekeyBytes = this.getBytes(cachekey);
        List r = this.redis.hashCommands().hMGet(cachekeyBytes, (byte[][])karr);
        ArrayList<TValue> list = null;
        if (r != null) {
            list = new ArrayList<TValue>(r.size());
            for (byte[] b : r) {
                list.add(this.deserialize(b, this.valueClass));
            }
        }
        return list;
    }

    @Override
    public List<TField> geTFields(Object ... args) throws Exception {
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cachekeyBytes = this.getBytes(cachekey);
        Set r = this.redis.hashCommands().hKeys(cachekeyBytes);
        ArrayList<TField> list = null;
        if (r != null) {
            list = new ArrayList<TField>(r.size());
            for (byte[] b : r) {
                list.add(this.deserialize(b, this.fieldClass));
            }
        }
        return list;
    }

    @Override
    public List<TValue> getValues(Object ... args) throws Exception {
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cachekeyBytes = this.getBytes(cachekey);
        List r = this.redis.hashCommands().hVals(cachekeyBytes);
        ArrayList<TValue> list = null;
        if (r != null) {
            list = new ArrayList<TValue>(r.size());
            for (byte[] b : r) {
                list.add(this.deserialize(b, this.valueClass));
            }
        }
        return list;
    }

    @Override
    public long getCount(Object ... args) throws Exception {
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cachekeyBytes = this.getBytes(cachekey);
        Long r = this.redis.hashCommands().hLen(cachekeyBytes);
        return r == null ? 0L : r;
    }

    @Override
    public boolean exists(TField field, Object ... args) throws Exception {
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cachekeyBytes = this.getBytes(cachekey);
        Boolean r = this.redis.hashCommands().hExists(cachekeyBytes, this.serialize(field));
        return r == null ? false : r;
    }

    @Override
    public boolean delete(TField field, Object ... args) throws Exception {
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cachekeyBytes = this.getBytes(cachekey);
        Long r = this.redis.hashCommands().hDel(cachekeyBytes, (byte[][])new byte[][]{this.serialize(field)});
        return r != null && r > 0L;
    }

    @Override
    public long delete(List<TField> fields, Object ... args) throws Exception {
        if (fields == null) {
            throw new Exception("fields is null!");
        }
        if (fields.size() == 0) {
            return 0L;
        }
        byte[][] karr = new byte[fields.size()][];
        for (int i = 0; i < fields.size(); ++i) {
            TField k = fields.get(i);
            if (k == null) {
                throw new Exception("fields item is null!");
            }
            karr[i] = this.serialize(k);
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cachekeyBytes = this.getBytes(cachekey);
        Long r = this.redis.hashCommands().hDel(cachekeyBytes, (byte[][])karr);
        return r == null ? 0L : r;
    }

    @Override
    public long increment(TField field, long incrementValue, Object ... args) throws Exception {
        if (field == null) {
            throw new Exception("field is null!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cachekeyBytes = this.getBytes(cachekey);
        Long r = this.redis.hashCommands().hIncrBy(cachekeyBytes, this.serialize(field), incrementValue);
        return r == null ? 0L : r;
    }

    @Override
    public long decrement(TField field, long decrementValue, Object ... args) throws Exception {
        if (field == null) {
            throw new Exception("field is null!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cachekeyBytes = this.getBytes(cachekey);
        Long r = this.redis.hashCommands().hIncrBy(cachekeyBytes, this.serialize(field), -decrementValue);
        return r == null ? 0L : r;
    }

    @Override
    public ICacheCursor<Map.Entry<TField, TValue>> scan(String pattern, int count, Object ... args) throws Exception {
        if (pattern == null) {
            throw new Exception("pattern is null!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        byte[] cachekeyBytes = this.getBytes(cachekey);
        ScanOptions op = ScanOptions.scanOptions().count((long)count).match(this.serialize(pattern)).build();
        Cursor r = this.redis.hashCommands().hScan(cachekeyBytes, op);
        return new HashCursor((Cursor<Map.Entry<byte[], byte[]>>)r, this.fieldClass, this.valueClass);
    }

    public class HashCursor
    implements ICacheCursor<Map.Entry<TField, TValue>> {
        private Cursor<Map.Entry<byte[], byte[]>> cursor;
        private Class<TField> keyClazz;
        private Class<TValue> valueClazz;

        public HashCursor(Cursor<Map.Entry<byte[], byte[]>> cursor, Class<TField> keyClazz, Class<TValue> valueClazz) {
            this.cursor = cursor;
            this.keyClazz = keyClazz;
            this.valueClazz = valueClazz;
        }

        @Override
        public void close() {
            if (this.cursor != null) {
                this.cursor.close();
                this.cursor = null;
                this.keyClazz = null;
                this.valueClazz = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.cursor.hasNext();
        }

        @Override
        public Map.Entry<TField, TValue> next() {
            Map.Entry n = (Map.Entry)this.cursor.next();
            HEntry hn = null;
            try {
                Object k = HashCache.this.deserialize((byte[])n.getKey(), this.keyClazz);
                Object v = HashCache.this.deserialize((byte[])n.getValue(), this.valueClazz);
                hn = new HEntry(k, v);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return hn;
        }
    }

    public class HEntry
    implements Map.Entry<TField, TValue> {
        private TField key;
        private TValue value;

        public HEntry(TField key, TValue value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public TField getKey() {
            return this.key;
        }

        @Override
        public TValue getValue() {
            return this.value;
        }

        @Override
        public TValue setValue(TValue arg0) {
            Object v = this.value;
            this.value = arg0;
            return v;
        }
    }
}

