/*
 * Decompiled with CFR 0.152.
 */
package cn.myafx.cache.base;

import cn.myafx.cache.DistUnit;
import cn.myafx.cache.GeoInfo;
import cn.myafx.cache.GeoPos;
import cn.myafx.cache.GeoRadius;
import cn.myafx.cache.ICacheKey;
import cn.myafx.cache.Sort;
import cn.myafx.cache.base.IGeoCache;
import cn.myafx.cache.base.RedisCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.data.domain.Sort;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.domain.geo.Metrics;

public class GeoCache
extends RedisCache
implements IGeoCache {
    public GeoCache(String node, String item, RedisConnection redisConnection, ICacheKey cacheKey, String prefix) throws Exception {
        super(node, item, redisConnection, cacheKey, prefix);
    }

    @Override
    public boolean addOrUpdate(String name, double lon, double lat, Object ... args) throws Exception {
        if (name == null || name.isEmpty()) {
            throw new Exception("name is null!");
        }
        Point point = GeoPos.toPoint(lon, lat);
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        Long r = this.redis.geoCommands().geoAdd(this.getBytes(cachekey), point, this.getBytes(name));
        return r != null && r > 0L;
    }

    @Override
    public boolean addOrUpdate(String name, GeoPos pos, Object ... args) throws Exception {
        if (pos == null) {
            throw new Exception("pos is null!");
        }
        return this.addOrUpdate(name, pos.Lon, pos.Lat, args);
    }

    @Override
    public boolean addOrUpdate(GeoInfo m, Object ... args) throws Exception {
        if (m == null) {
            throw new Exception("m is null!");
        }
        return this.addOrUpdate(m.Name, m.Position, args);
    }

    @Override
    public long addOrUpdate(List<GeoInfo> list, Object ... args) throws Exception {
        if (list == null) {
            throw new Exception("list is null!");
        }
        if (list.size() == 0) {
            return 0L;
        }
        HashMap<byte[], Point> map = new HashMap<byte[], Point>(list.size());
        for (GeoInfo gm : list) {
            if (gm == null) {
                throw new Exception("list item is null!");
            }
            if (gm.Name == null || gm.Name.isEmpty()) {
                throw new Exception("list item.Name is null!");
            }
            if (gm.Position == null) {
                throw new Exception("list item.Position is null!");
            }
            map.put(this.getBytes(gm.Name), new Point(gm.Position.Lon, gm.Position.Lat));
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        Long r = this.redis.geoCommands().geoAdd(this.getBytes(cachekey), map);
        return r == null ? 0L : r;
    }

    @Override
    public GeoPos get(String name, Object ... args) throws Exception {
        Point p;
        if (name == null || name.isEmpty()) {
            throw new Exception("name is null!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        List rlist = this.redis.geoCommands().geoPos(this.getBytes(cachekey), (byte[][])new byte[][]{this.getBytes(name)});
        GeoPos m = null;
        if (rlist != null && rlist.size() > 0 && (p = (Point)rlist.get(0)) != null) {
            m = GeoPos.toGeoPos(p);
        }
        return m;
    }

    @Override
    public List<GeoPos> get(List<String> names, Object ... args) throws Exception {
        if (names == null) {
            throw new Exception("names is null!");
        }
        if (names.size() == 0) {
            return new ArrayList<GeoPos>(0);
        }
        byte[][] marr = new byte[names.size()][];
        for (int i = 0; i < names.size(); ++i) {
            String name = names.get(i);
            if (name == null || name.isEmpty()) {
                throw new Exception("name is null!");
            }
            marr[i] = this.getBytes(name);
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        List rlist = this.redis.geoCommands().geoPos(this.getBytes(cachekey), (byte[][])marr);
        ArrayList<GeoPos> list = null;
        if (rlist != null) {
            list = new ArrayList<GeoPos>(rlist.size());
            for (Point p : rlist) {
                list.add(GeoPos.toGeoPos(p));
            }
        }
        return list;
    }

    private Metric getMetric(DistUnit unit) {
        switch (unit) {
            case km: {
                return Metrics.KILOMETERS;
            }
            case mi: {
                return Metrics.MILES;
            }
            case ft: {
                return Metrics.FEET;
            }
        }
        return Metrics.METERS;
    }

    @Override
    public Double getDist(String firstName, String secondName, DistUnit unit, Object ... args) throws Exception {
        if (firstName == null || firstName.isEmpty()) {
            throw new Exception("firstName is null!");
        }
        if (secondName == null || secondName.isEmpty()) {
            throw new Exception("secondName is null!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        Distance r = this.redis.geoCommands().geoDist(this.getBytes(cachekey), this.getBytes(firstName), this.getBytes(secondName), this.getMetric(unit));
        return r != null ? Double.valueOf(r.getValue()) : null;
    }

    @Override
    public String getGeoHash(String name, Object ... args) throws Exception {
        if (name == null || name.isEmpty()) {
            throw new Exception("name is null!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        List rlist = this.redis.geoCommands().geoHash(this.getBytes(cachekey), (byte[][])new byte[][]{this.getBytes(name)});
        return rlist != null && rlist.size() > 0 ? (String)rlist.get(0) : null;
    }

    @Override
    public List<String> getGeoHash(List<String> names, Object ... args) throws Exception {
        if (names == null) {
            throw new Exception("names is null!");
        }
        if (names.size() == 0) {
            return new ArrayList<String>(0);
        }
        byte[][] marr = new byte[names.size()][];
        for (int i = 0; i < names.size(); ++i) {
            String name = names.get(i);
            if (name == null || name.isEmpty()) {
                throw new Exception("name is null!");
            }
            marr[i] = this.getBytes(name);
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        List rlist = this.redis.geoCommands().geoHash(this.getBytes(cachekey), (byte[][])marr);
        return rlist;
    }

    @Override
    public boolean delete(String name, Object ... args) throws Exception {
        if (name == null || name.isEmpty()) {
            throw new Exception("name is null!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        Long r = this.redis.geoCommands().geoRemove(this.getBytes(cachekey), (byte[][])new byte[][]{this.getBytes(name)});
        return r != null && r > 0L;
    }

    private RedisGeoCommands.GeoRadiusCommandArgs getOption(int radiusOptions, int count, Sort sort) {
        RedisGeoCommands.GeoRadiusCommandArgs op = RedisGeoCommands.GeoRadiusCommandArgs.newGeoRadiusArgs();
        if (radiusOptions == 0 || (radiusOptions & 1) == 1) {
            op.includeCoordinates();
        }
        if (radiusOptions == 0 || (radiusOptions & 2) == 2) {
            op.includeDistance();
        }
        if (count > 0) {
            op.limit((long)count);
        }
        op.sort(sort == Sort.Asc ? Sort.Direction.ASC : Sort.Direction.DESC);
        return op;
    }

    @Override
    public List<GeoRadius> getRadius(String name, double radius, DistUnit unit, int count, Sort sort, int radiusOptions, Object ... args) throws Exception {
        if (name == null || name.isEmpty()) {
            throw new Exception("name is null!");
        }
        if (radius < 0.0) {
            throw new Exception("radius = " + radius + " is error!");
        }
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        Distance distance = new Distance(radius, this.getMetric(unit));
        RedisGeoCommands.GeoRadiusCommandArgs op = this.getOption(radiusOptions, count, sort);
        GeoResults rlist = this.redis.geoCommands().geoRadiusByMember(this.getBytes(cachekey), this.getBytes(name), distance, op);
        ArrayList<GeoRadius> list = null;
        if (rlist != null) {
            List rclist = rlist.getContent();
            list = new ArrayList<GeoRadius>(rclist.size());
            for (GeoResult gr : rclist) {
                GeoRadius m = null;
                if (gr != null) {
                    RedisGeoCommands.GeoLocation gn = (RedisGeoCommands.GeoLocation)gr.getContent();
                    Distance d = gr.getDistance();
                    Point p = gn.getPoint();
                    String rname = this.getString((byte[])gn.getName());
                    Double rdistance = d != null ? Double.valueOf(d.getValue()) : null;
                    GeoPos rposition = GeoPos.toGeoPos(p);
                    m = new GeoRadius(rname, rdistance, rposition);
                }
                list.add(m);
            }
        }
        return list;
    }

    @Override
    public List<GeoRadius> getRadius(double lon, double lat, double radius, DistUnit unit, int count, Sort sort, int radiusOptions, Object ... args) throws Exception {
        Point point = GeoPos.toPoint(lon, lat);
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        Distance distance = new Distance(radius, this.getMetric(unit));
        Circle circle = new Circle(point, distance);
        RedisGeoCommands.GeoRadiusCommandArgs op = this.getOption(radiusOptions, count, sort);
        GeoResults rlist = this.redis.geoCommands().geoRadius(this.getBytes(cachekey), circle, op);
        ArrayList<GeoRadius> list = null;
        if (rlist != null) {
            List rclist = rlist.getContent();
            list = new ArrayList<GeoRadius>(rclist.size());
            for (GeoResult gr : rclist) {
                GeoRadius m = null;
                if (gr != null) {
                    RedisGeoCommands.GeoLocation gn = (RedisGeoCommands.GeoLocation)gr.getContent();
                    Distance d = gr.getDistance();
                    Point p = gn.getPoint();
                    String rname = this.getString((byte[])gn.getName());
                    Double rdistance = d != null ? Double.valueOf(d.getValue()) : null;
                    GeoPos rposition = GeoPos.toGeoPos(p);
                    m = new GeoRadius(rname, rdistance, rposition);
                }
                list.add(m);
            }
        }
        return list;
    }

    @Override
    public long getCount(Object ... args) throws Exception {
        String cachekey = this.getCacheKey(args);
        int db = this.getCacheDb(cachekey);
        this.redis.select(db);
        Long count = this.redis.zSetCommands().zCount(this.getBytes(cachekey), Double.MIN_VALUE, Double.MAX_VALUE);
        return count == null ? 0L : count;
    }
}

