/*
 * Decompiled with CFR 0.152.
 */
package cn.myafx.cache;

import cn.myafx.cache.ICacheKey;
import cn.myafx.cache.IJsonMapper;
import cn.myafx.cache.base.IHashCache;
import cn.myafx.cache.base.IRedisCache;
import cn.myafx.cache.base.IValueCache;
import cn.myafx.cache.base.RedisCache;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;

public class CacheFactory
implements AutoCloseable {
    private RedisConnectionFactory connectionFactory;
    private ICacheKey cacheKey;
    private String prefix;
    private IJsonMapper mapper;

    public CacheFactory(RedisConnectionFactory connectionFactory, ICacheKey cacheKey, String prefix, IJsonMapper jsonMapper) throws Exception {
        if (connectionFactory == null) {
            throw new Exception("connectionFactory is null!");
        }
        if (cacheKey == null) {
            throw new Exception("cacheKey is null!");
        }
        if (jsonMapper == null) {
            throw new Exception("jsonMapper is null!");
        }
        this.connectionFactory = connectionFactory;
        this.cacheKey = cacheKey;
        this.prefix = prefix;
        if (this.prefix == null) {
            this.prefix = "";
        }
        this.mapper = jsonMapper;
        RedisCache.DefaultJsonMapper = jsonMapper;
    }

    public RedisConnection getConnection() throws Exception {
        return this.connectionFactory.getClusterConnection();
    }

    public ICacheKey getCacheKey() {
        return this.cacheKey;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public IJsonMapper getObjectMapper() {
        return this.mapper;
    }

    public <T extends IRedisCache> T getCache(String item, Class<T> clazz) throws Exception {
        if (item == null || item.isEmpty()) {
            throw new Exception("item is null!");
        }
        if (clazz == null) {
            throw new Exception("clazz is null!");
        }
        String[] arr = item.split(":");
        if (arr.length > 2) {
            throw new Exception("item=" + item + " is error!");
        }
        Class<Object> impClass = clazz;
        String sname = clazz.getSimpleName();
        if (sname.startsWith("I")) {
            String name = clazz.getName();
            String className = name.substring(0, name.length() - sname.length()) + sname.substring(1);
            impClass = Class.forName(className);
        }
        if (impClass == null) {
            throw new Exception("clazz(" + clazz.getName() + ") is error!");
        }
        IRedisCache cache = null;
        if (arr.length == 1) {
            c = impClass.getConstructor(String.class, RedisConnection.class, ICacheKey.class, String.class);
            if (c == null) {
                throw new Exception("clazz(" + clazz.getName() + ") is error!");
            }
            cache = (IRedisCache)c.newInstance(item, this.getConnection(), this.getCacheKey(), this.getPrefix());
        } else {
            c = impClass.getConstructor(String.class, String.class, RedisConnection.class, ICacheKey.class, String.class);
            if (c == null) {
                throw new Exception("clazz(" + clazz.getName() + ") is error!");
            }
            cache = (IRedisCache)c.newInstance(arr[0], arr[1], this.getConnection(), this.getCacheKey(), this.getPrefix());
        }
        return (T)cache;
    }

    public <T extends IValueCache<TValue>, TValue> T getCache(String item, Class<T> clazz, Class<TValue> valueClass) throws Exception {
        if (item == null || item.isEmpty()) {
            throw new Exception("item is null!");
        }
        if (clazz == null) {
            throw new Exception("clazz is null!");
        }
        if (valueClass == null) {
            throw new Exception("valueClass is null!");
        }
        String[] arr = item.split(":");
        if (arr.length > 2) {
            throw new Exception("item=" + item + " is error!");
        }
        Class<Object> impClass = clazz;
        String sname = clazz.getSimpleName();
        if (sname.startsWith("I")) {
            String name = clazz.getName();
            String className = name.substring(0, name.length() - sname.length()) + sname.substring(1);
            impClass = Class.forName(className);
        }
        if (impClass == null) {
            throw new Exception("clazz(" + clazz.getName() + ") is error!");
        }
        IValueCache cache = null;
        if (arr.length == 1) {
            c = impClass.getConstructor(String.class, RedisConnection.class, ICacheKey.class, String.class, Class.class);
            if (c == null) {
                throw new Exception("clazz(" + clazz.getName() + ") is error!");
            }
            cache = (IValueCache)c.newInstance(item, this.getConnection(), this.getCacheKey(), this.getPrefix(), valueClass);
        } else {
            c = impClass.getConstructor(String.class, String.class, RedisConnection.class, ICacheKey.class, String.class, Class.class);
            if (c == null) {
                throw new Exception("clazz(" + clazz.getName() + ") is error!");
            }
            cache = (IValueCache)c.newInstance(arr[0], arr[1], this.getConnection(), this.getCacheKey(), this.getPrefix(), valueClass);
        }
        return (T)cache;
    }

    public <T extends IHashCache<TField, TValue>, TField, TValue> T getCache(String item, Class<T> clazz, Class<TField> fieldClass, Class<TValue> valueClass) throws Exception {
        if (item == null || item.isEmpty()) {
            throw new Exception("item is null!");
        }
        if (clazz == null) {
            throw new Exception("clazz is null!");
        }
        if (fieldClass == null) {
            throw new Exception("fieldClass is null!");
        }
        if (valueClass == null) {
            throw new Exception("valueClass is null!");
        }
        String[] arr = item.split(":");
        if (arr.length > 2) {
            throw new Exception("item=" + item + " is error!");
        }
        Class<Object> impClass = clazz;
        String sname = clazz.getSimpleName();
        if (sname.startsWith("I")) {
            String name = clazz.getName();
            String className = name.substring(0, name.length() - sname.length()) + sname.substring(1);
            impClass = Class.forName(className);
        }
        if (impClass == null) {
            throw new Exception("clazz(" + clazz.getName() + ") is error!");
        }
        IHashCache cache = null;
        if (arr.length == 1) {
            c = impClass.getConstructor(String.class, RedisConnection.class, ICacheKey.class, String.class, Class.class, Class.class);
            if (c == null) {
                throw new Exception("clazz(" + clazz.getName() + ") is error!");
            }
            cache = (IHashCache)c.newInstance(item, this.getConnection(), this.getCacheKey(), this.getPrefix(), fieldClass, valueClass);
        } else {
            c = impClass.getConstructor(String.class, String.class, RedisConnection.class, ICacheKey.class, String.class, Class.class, Class.class);
            if (c == null) {
                throw new Exception("clazz(" + clazz.getName() + ") is error!");
            }
            cache = (IHashCache)c.newInstance(arr[0], arr[1], this.getConnection(), this.getCacheKey(), this.getPrefix(), fieldClass, valueClass);
        }
        return (T)cache;
    }

    @Override
    public void close() throws Exception {
        this.connectionFactory = null;
        this.cacheKey = null;
        this.prefix = null;
        this.mapper = null;
    }
}

