package cn.mvapi.message.sms.service;


import java.util.HashMap;
import java.util.List;

/**
 * 短信服务
 */
public interface SmsService {
    /**
     * 发送短信 参数为code
     * @param phone 手机号
     * @param code 验证码
     */
    void sendSms(String phone, String code);

    /**
     * 发送短信
     * @param phone 手机号
     * @param params 短信参数
     */
    void sendSms(String phone, HashMap<String, Object> params);

    /**
     * 发送短信
     * @param phones 手机号集合
     * @param params 短信参数
     */
    void sendSms(List<String> phones, HashMap<String, Object> params);

    /**
     * 发送短信
     * @param smsType 短信类型
     * @param phones 手机号集合
     * @param templateId 短信模板
     * @param tempNameCode 短信模板code
     * @param params 短信参数
     */
    void sendSms(String smsType, List<String> phones, Long templateId, String tempNameCode, HashMap<String, Object> params);

    /**
     * 发送验证码
     * @param phone 手机号
     * @param smsCodeType 验证码类型 自定义英文单词 比如：login、register、resetPassword
     * @param smsTemplateCode 验证码模板code
     */
    void sendSmsCode(String phone, String smsCodeType, String smsTemplateCode);

    /**
     * 校验短信验证码
     * @param phone 手机号
     * @param smsCodeType 短信类型 自定义英文单词 比如：register、login、modifyPassword
     * @param code 验证码
     */
    boolean checkPhoneCode(String phone, String smsCodeType, String code);
}
