package cn.mvapi.data.mysql.pojo.enums;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author shibaolin
 */
@AllArgsConstructor
@Getter
public enum SqlOperateTypeEnum {
    // 数据库表操作类型
    CREATE_TABLE("create_table", "创建表", 0),
    MODIFY_TABLE_COMMENT("modify_table_comment", "修改表注释", 0),
    MODIFY_COLUMN_COMMENT("modify_column_comment", "修改字段注释", 0),
    MODIFY_COLUMN_TYPE("modify_column_type", "修改表字段类型", 3),
    MODIFY_COLUMN_DEFAULT("modify_column_default", "修改表字段默认值", 1),
    ADD_COLUMN("add_column", "增加表字段", 0),
    DELETE_COLUMN("delete_column", "删除表字段", 9),
    DELETE_TABLE("delete_table", "删除表", 10),
    ADD_INDEX("add_index", "新增索引", 0),
    DELETE_INDEX("delete_index", "删除索引", 0),
    RENAME_TABLE("rename_table", "重命名表", 2),
    RENAME_COLUMN("rename_column", "重命名字段", 2),
;
    @ApiModelProperty(value = "code")
    private String code;
    @ApiModelProperty(value = "名称")
    private String name ;
    @ApiModelProperty(value = "风险等级")
    private Integer riskLevel;
}
