-- create database mt_open_admin;
CREATE TABLE sys_api_interface  (
  interface_id bigint(22) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  project_id bigint(22) NULL DEFAULT NULL COMMENT '项目id',
  module_id bigint(22) NULL DEFAULT NULL COMMENT '模块id',
  interface_name varchar(128) NULL DEFAULT NULL COMMENT '接口名称',
  method varchar(32) NULL DEFAULT NULL COMMENT '请求方式GET/POST',
  path varchar(128) NULL DEFAULT NULL COMMENT '接口路径',
  status char(1) NULL DEFAULT NULL COMMENT '接口状态 0已完成 1未完成',
  request_header text NULL COMMENT '请求头',
  request_parameter text NULL COMMENT '请求参数',
  request_body text NULL COMMENT '请求体',
  response_data text NULL COMMENT '返回数据',
  remark mediumtext NULL COMMENT '备注',
  create_by varchar(64) NULL DEFAULT NULL COMMENT '创建者',
  create_time datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  update_by varchar(64) NULL DEFAULT NULL COMMENT '更新者',
  update_time datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (interface_id) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = 'api接口表';

CREATE TABLE sys_api_module  (
  module_id bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'API模块id',
  project_id bigint(20) NULL DEFAULT NULL COMMENT '所属项目',
  module_name varchar(100) NULL DEFAULT NULL COMMENT '模块名称',
  order_num tinyint(4) NULL DEFAULT NULL COMMENT '显示顺序',
  create_by varchar(64) NULL DEFAULT NULL COMMENT '创建者',
  create_time datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  update_by varchar(64) NULL DEFAULT NULL COMMENT '更新者',
  update_time datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (module_id) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = 'API模块';

CREATE TABLE sys_api_project  (
  project_id bigint(22) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '项目id',
  project_name varchar(100) NULL DEFAULT NULL COMMENT '项目名称',
  project_url varchar(64) NULL DEFAULT NULL COMMENT '项目路径',
  apikey varchar(64) NULL DEFAULT NULL COMMENT 'api密钥',
  status char(1) NULL DEFAULT NULL COMMENT '状态（0正常 1停用）',
  create_by varchar(64) NULL DEFAULT NULL COMMENT '创建者',
  create_time datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  update_by varchar(64) NULL DEFAULT NULL COMMENT '更新者',
  update_time datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  remark varchar(255) NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (project_id) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = 'API项目';

CREATE TABLE sys_config  (
  config_id int(5) NOT NULL AUTO_INCREMENT COMMENT '参数主键',
  config_name varchar(100) NULL DEFAULT '' COMMENT '参数名称',
  config_key varchar(100) NULL DEFAULT '' COMMENT '参数键名',
  config_value varchar(500) NULL DEFAULT '' COMMENT '参数键值',
  config_type char(1) NULL DEFAULT 'N' COMMENT '系统内置（Y是 N否）',
  create_by varchar(64) NULL DEFAULT '' COMMENT '创建者',
  create_time datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  update_by varchar(64) NULL DEFAULT '' COMMENT '更新者',
  update_time datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  remark varchar(500) NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (config_id) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = '参数配置表';

CREATE TABLE sys_dept  (
  dept_id bigint(20) NOT NULL AUTO_INCREMENT COMMENT '部门id',
  parent_id bigint(20) NULL DEFAULT 0 COMMENT '父部门id',
  ancestors varchar(50) NULL DEFAULT '' COMMENT '祖级列表',
  dept_name varchar(30) NULL DEFAULT '' COMMENT '部门名称',
  order_num int(4) NULL DEFAULT 0 COMMENT '显示顺序',
  leader varchar(20) NULL DEFAULT NULL COMMENT '负责人',
  phone varchar(11) NULL DEFAULT NULL COMMENT '联系电话',
  email varchar(50) NULL DEFAULT NULL COMMENT '邮箱',
  status char(1) NULL DEFAULT '0' COMMENT '部门状态（0正常 1停用）',
  del_flag char(1) NULL DEFAULT '0' COMMENT '删除标志（0代表存在 2代表删除）',
  create_by varchar(64) NULL DEFAULT '' COMMENT '创建者',
  create_time datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  update_by varchar(64) NULL DEFAULT '' COMMENT '更新者',
  update_time datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (dept_id) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = '部门表';

CREATE TABLE sys_dict_data  (
  dict_code bigint(20) NOT NULL AUTO_INCREMENT COMMENT '字典编码',
  dict_sort int(4) NULL DEFAULT 0 COMMENT '字典排序',
  dict_label varchar(100) NULL DEFAULT '' COMMENT '字典标签',
  dict_value varchar(100) NULL DEFAULT '' COMMENT '字典键值',
  dict_type varchar(100) NULL DEFAULT '' COMMENT '字典类型',
  css_class varchar(100) NULL DEFAULT NULL COMMENT '样式属性（其他样式扩展）',
  list_class varchar(100) NULL DEFAULT NULL COMMENT '表格回显样式',
  is_default char(1) NULL DEFAULT 'N' COMMENT '是否默认（Y是 N否）',
  status char(1) NULL DEFAULT '0' COMMENT '状态（0正常 1停用）',
  create_by varchar(64) NULL DEFAULT '' COMMENT '创建者',
  create_time datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  update_by varchar(64) NULL DEFAULT '' COMMENT '更新者',
  update_time datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  remark varchar(500) NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (dict_code) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = '字典数据表';

CREATE TABLE sys_dict_type  (
  dict_id bigint(20) NOT NULL AUTO_INCREMENT COMMENT '字典主键',
  dict_name varchar(100) NULL DEFAULT '' COMMENT '字典名称',
  dict_type varchar(100) NULL DEFAULT '' COMMENT '字典类型',
  status char(1) NULL DEFAULT '0' COMMENT '状态（0正常 1停用）',
  create_by varchar(64) NULL DEFAULT '' COMMENT '创建者',
  create_time datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  update_by varchar(64) NULL DEFAULT '' COMMENT '更新者',
  update_time datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  remark varchar(500) NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (dict_id) USING BTREE,
  UNIQUE INDEX dict_type(dict_type) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = '字典类型表';

CREATE TABLE sys_gen_column  (
  column_id bigint(20) NOT NULL AUTO_INCREMENT COMMENT '编号',
  table_id bigint(20) NULL DEFAULT NULL COMMENT '归属表编号',
  column_name varchar(200) NULL DEFAULT NULL COMMENT '列名称',
  column_comment varchar(500) NULL DEFAULT NULL COMMENT '列描述',
  column_type varchar(100) NULL DEFAULT NULL COMMENT '列类型',
  java_type varchar(500) NULL DEFAULT NULL COMMENT 'JAVA类型',
  java_field varchar(200) NULL DEFAULT NULL COMMENT 'JAVA字段名',
  is_pk char(1) NULL DEFAULT NULL COMMENT '是否主键（1是）',
  is_increment char(1) NULL DEFAULT NULL COMMENT '是否自增（1是）',
  is_required char(1) NULL DEFAULT NULL COMMENT '是否必填（1是）',
  is_insert char(1) NULL DEFAULT NULL COMMENT '是否为插入字段（1是）',
  is_export char(1) NULL DEFAULT NULL COMMENT '是否为导出字段（1是）',
  is_edit char(1) NULL DEFAULT NULL COMMENT '是否编辑字段（1是）',
  is_list char(1) NULL DEFAULT NULL COMMENT '是否列表字段（1是）',
  is_query char(1) NULL DEFAULT NULL COMMENT '是否查询字段（1是）',
  query_type varchar(200) NULL DEFAULT 'EQ' COMMENT '查询方式（等于、不等于、大于、小于、范围）',
  html_type varchar(200) NULL DEFAULT NULL COMMENT '显示类型（文本框、文本域、下拉框、复选框、单选框、日期控件）',
  dict_type varchar(200) NULL DEFAULT '' COMMENT '字典类型',
  sort int(11) NULL DEFAULT NULL COMMENT '排序',
  create_by varchar(64) NULL DEFAULT '' COMMENT '创建者',
  create_time datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  update_by varchar(64) NULL DEFAULT '' COMMENT '更新者',
  update_time datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (column_id) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = '代码生成业务字段';

CREATE TABLE sys_gen_table  (
  table_id bigint(20) NOT NULL AUTO_INCREMENT COMMENT '编号',
  table_name varchar(200) NULL DEFAULT '' COMMENT '表名称',
  table_comment varchar(500) NULL DEFAULT '' COMMENT '表描述',
  sub_table_name varchar(64) NULL DEFAULT NULL COMMENT '关联子表的表名',
  sub_table_fk_name varchar(64) NULL DEFAULT NULL COMMENT '子表关联的外键名',
  class_name varchar(100) NULL DEFAULT '' COMMENT '实体类名称',
  tpl_category varchar(200) NULL DEFAULT 'crud' COMMENT '使用的模板（crud单表操作 tree树表操作）',
  package_name varchar(100) NULL DEFAULT NULL COMMENT '生成包路径',
  module_name varchar(30) NULL DEFAULT NULL COMMENT '生成模块名',
  business_name varchar(30) NULL DEFAULT NULL COMMENT '生成业务名',
  function_name varchar(50) NULL DEFAULT NULL COMMENT '生成功能名',
  function_author varchar(50) NULL DEFAULT NULL COMMENT '生成功能作者',
  gen_type char(1) NULL DEFAULT '0' COMMENT '生成代码方式（0zip压缩包 1自定义路径）',
  gen_path varchar(200) NULL DEFAULT '/' COMMENT '生成路径（不填默认项目路径）',
  options varchar(1000) NULL DEFAULT NULL COMMENT '其它生成选项',
  create_by varchar(64) NULL DEFAULT '' COMMENT '创建者',
  create_time datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  update_by varchar(64) NULL DEFAULT '' COMMENT '更新者',
  update_time datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  remark varchar(500) NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (table_id) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = '代码生成业务表';

CREATE TABLE sys_login_log  (
  info_id bigint(20) NOT NULL AUTO_INCREMENT COMMENT '访问ID',
  user_name varchar(50) NULL DEFAULT '' COMMENT '用户账号',
  ipaddr varchar(128) NULL DEFAULT '' COMMENT '登录IP地址',
  login_location varchar(255) NULL DEFAULT '' COMMENT '登录地点',
  browser varchar(50) NULL DEFAULT '' COMMENT '浏览器类型',
  os varchar(50) NULL DEFAULT '' COMMENT '操作系统',
  status char(1) NULL DEFAULT '0' COMMENT '登录状态（0成功 1失败）',
  msg varchar(255) NULL DEFAULT '' COMMENT '提示消息',
  login_time datetime(0) NULL DEFAULT NULL COMMENT '访问时间',
  PRIMARY KEY (info_id) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = '系统访问记录';

CREATE TABLE sys_menu  (
  menu_id bigint(20) NOT NULL AUTO_INCREMENT COMMENT '菜单ID',
  menu_name varchar(50) NOT NULL COMMENT '菜单名称',
  parent_id bigint(20) NULL DEFAULT 0 COMMENT '父菜单ID',
  order_num int(4) NULL DEFAULT 0 COMMENT '显示顺序',
  path varchar(200) NULL DEFAULT '' COMMENT '路由地址',
  component varchar(255) NULL DEFAULT NULL COMMENT '组件路径',
  query varchar(255) NULL DEFAULT NULL COMMENT '路由参数',
  is_frame int(1) NULL DEFAULT 1 COMMENT '是否为外链（0是 1否）',
  is_cache int(1) NULL DEFAULT 0 COMMENT '是否缓存（0缓存 1不缓存）',
  menu_type char(1) NULL DEFAULT '' COMMENT '菜单类型（M目录 C菜单 F按钮）',
  visible char(1) NULL DEFAULT '0' COMMENT '菜单状态（0显示 1隐藏）',
  status char(1) NULL DEFAULT '0' COMMENT '菜单状态（0正常 1停用）',
  perms varchar(100) NULL DEFAULT NULL COMMENT '权限标识',
  icon varchar(100) NULL DEFAULT '#' COMMENT '菜单图标',
  create_by varchar(64) NULL DEFAULT '' COMMENT '创建者',
  create_time datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  update_by varchar(64) NULL DEFAULT '' COMMENT '更新者',
  update_time datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  remark varchar(500) NULL DEFAULT '' COMMENT '备注',
  PRIMARY KEY (menu_id) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = '菜单权限表';

CREATE TABLE sys_notice  (
  notice_id int(4) NOT NULL AUTO_INCREMENT COMMENT '公告ID',
  notice_title varchar(50) NOT NULL COMMENT '公告标题',
  notice_type char(1) NOT NULL COMMENT '公告类型（1通知 2公告）',
  notice_content longtext NULL COMMENT '公告内容',
  status char(1) NULL DEFAULT '0' COMMENT '公告状态（0正常 1关闭）',
  create_by varchar(64) NULL DEFAULT '' COMMENT '创建者',
  create_time datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  update_by varchar(64) NULL DEFAULT '' COMMENT '更新者',
  update_time datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  remark varchar(255) NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (notice_id) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = '通知公告表';

CREATE TABLE sys_oper_log  (
  oper_id bigint(20) NOT NULL AUTO_INCREMENT COMMENT '日志主键',
  title varchar(50) NULL DEFAULT '' COMMENT '模块标题',
  business_type int(2) NULL DEFAULT 0 COMMENT '业务类型（0其它 1新增 2修改 3删除）',
  method varchar(100) NULL DEFAULT '' COMMENT '方法名称',
  request_method varchar(10) NULL DEFAULT '' COMMENT '请求方式',
  operator_type int(1) NULL DEFAULT 0 COMMENT '操作类别（0其它 1后台用户 2手机端用户）',
  oper_name varchar(50) NULL DEFAULT '' COMMENT '操作人员',
  dept_name varchar(50) NULL DEFAULT '' COMMENT '部门名称',
  oper_url varchar(255) NULL DEFAULT '' COMMENT '请求URL',
  oper_ip varchar(128) NULL DEFAULT '' COMMENT '主机地址',
  oper_location varchar(255) NULL DEFAULT '' COMMENT '操作地点',
  oper_param varchar(2000) NULL DEFAULT '' COMMENT '请求参数',
  json_result varchar(2000) NULL DEFAULT '' COMMENT '返回参数',
  status int(1) NULL DEFAULT 0 COMMENT '操作状态（0正常 1异常）',
  error_msg varchar(2000) NULL DEFAULT '' COMMENT '错误消息',
  oper_time datetime(0) NULL DEFAULT NULL COMMENT '操作时间',
  PRIMARY KEY (oper_id) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = '操作日志记录';

CREATE TABLE sys_post  (
  post_id bigint(20) NOT NULL AUTO_INCREMENT COMMENT '岗位ID',
  post_code varchar(64) NOT NULL COMMENT '岗位编码',
  post_name varchar(50) NOT NULL COMMENT '岗位名称',
  post_sort int(4) NOT NULL COMMENT '显示顺序',
  status char(1) NOT NULL COMMENT '状态（0正常 1停用）',
  create_by varchar(64) NULL DEFAULT '' COMMENT '创建者',
  create_time datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  update_by varchar(64) NULL DEFAULT '' COMMENT '更新者',
  update_time datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  remark varchar(500) NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (post_id) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = '岗位表';

CREATE TABLE sys_role  (
  role_id bigint(20) NOT NULL AUTO_INCREMENT COMMENT '角色ID',
  role_name varchar(30) NOT NULL COMMENT '角色名称',
  role_key varchar(100) NOT NULL COMMENT '角色权限字符串',
  role_sort int(4) NOT NULL COMMENT '显示顺序',
  menu_check_strictly tinyint(1) NULL DEFAULT 1 COMMENT '菜单树选择项是否关联显示',
  dept_check_strictly tinyint(1) NULL DEFAULT 1 COMMENT '部门树选择项是否关联显示',
  status char(1) NOT NULL COMMENT '角色状态（0正常 1停用）',
  del_flag char(1) NULL DEFAULT '0' COMMENT '删除标志（0代表存在 2代表删除）',
  create_by varchar(64) NULL DEFAULT '' COMMENT '创建者',
  create_time datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  update_by varchar(64) NULL DEFAULT '' COMMENT '更新者',
  update_time datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  remark varchar(500) NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (role_id) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = '角色表';

CREATE TABLE sys_role_dept  (
  role_id bigint(20) NOT NULL COMMENT '角色ID',
  dept_id bigint(20) NOT NULL COMMENT '部门ID',
  PRIMARY KEY (role_id, dept_id) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = '角色和部门关联表';

CREATE TABLE sys_role_menu  (
  role_id bigint(20) NOT NULL COMMENT '角色ID',
  menu_id bigint(20) NOT NULL COMMENT '菜单ID',
  PRIMARY KEY (role_id, menu_id) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = '角色和菜单关联表';

CREATE TABLE sys_user  (
  user_id bigint(20) NOT NULL AUTO_INCREMENT COMMENT '用户ID',
  dept_id bigint(20) NULL DEFAULT NULL COMMENT '部门ID',
  user_name varchar(30) NOT NULL COMMENT '用户账号',
  nick_name varchar(30) NOT NULL COMMENT '用户昵称',
  user_type varchar(2) NULL DEFAULT '00' COMMENT '用户类型（00系统用户）',
  email varchar(50) NULL DEFAULT '' COMMENT '用户邮箱',
  phone_number varchar(11) NULL DEFAULT '' COMMENT '手机号码',
  sex char(1) NULL DEFAULT '0' COMMENT '用户性别（0男 1女 2未知）',
  avatar varchar(100) NULL DEFAULT '' COMMENT '头像地址',
  password varchar(100) NULL DEFAULT '' COMMENT '密码',
  status char(1) NULL DEFAULT '0' COMMENT '帐号状态（0正常 1停用）',
  del_flag char(1) NULL DEFAULT '0' COMMENT '删除标志（0代表存在 2代表删除）',
  login_ip varchar(128) NULL DEFAULT '' COMMENT '最后登录IP',
  login_date datetime(0) NULL DEFAULT NULL COMMENT '最后登录时间',
  create_by varchar(64) NULL DEFAULT '' COMMENT '创建者',
  create_time datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  update_by varchar(64) NULL DEFAULT '' COMMENT '更新者',
  update_time datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  remark varchar(500) NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (user_id) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = '用户表';

CREATE TABLE sys_user_post  (
  user_id bigint(20) NOT NULL COMMENT '用户ID',
  post_id bigint(20) NOT NULL COMMENT '岗位ID',
  PRIMARY KEY (user_id, post_id) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = '用户与岗位关联表';

CREATE TABLE sys_user_role  (
  user_id bigint(20) NOT NULL COMMENT '用户ID',
  role_id bigint(20) NOT NULL COMMENT '角色ID',
  PRIMARY KEY (user_id, role_id) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = '用户和角色关联表';

-- 下面是初始数据
INSERT INTO sys_config VALUES (1, '主框架页-默认皮肤样式名称', 'sys.index.skinName', 'skin-blue', 'Y', 'openadmin', now(), '', NULL, '蓝色 skin-blue、绿色 skin-green、紫色 skin-purple、红色 skin-red、黄色 skin-yellow');
INSERT INTO sys_config VALUES (2, '用户管理-账号初始密码', 'sys.user.initPassword', 'Openadmin9986', 'Y', 'openadmin', now(), '', NULL, '初始化密码 Openadmin9986');
INSERT INTO sys_config VALUES (3, '主框架页-侧边栏主题', 'sys.index.sideTheme', 'theme-dark', 'Y', 'openadmin', now(), '', NULL, '深色主题theme-dark，浅色主题theme-light');
INSERT INTO sys_config VALUES (4, '账号自助-验证码开关', 'sys.account.captchaEnabled', 'true', 'Y', 'openadmin', now(), '', NULL, '是否开启验证码功能（true开启，false关闭）');
INSERT INTO sys_config VALUES (5, '账号自助-是否开启用户注册功能', 'sys.account.registerUser', 'false', 'Y', 'openadmin', now(), '', NULL, '是否开启注册用户功能（true开启，false关闭）');

INSERT INTO sys_dept VALUES (1, 0, '0', 'Openadmin', 0, 'openadmin', '13866669999', 'openadmin@morethank.cn', '0', '0', 'openadmin', now(), '', NULL);
INSERT INTO sys_dept VALUES (2, 1, '0,1', '北京总公司', 1, 'openadmin', '13866669999', 'openadmin@morethank.cn', '0', '0', 'openadmin', now(), '', NULL);

INSERT INTO sys_dict_data VALUES (1, 1, '男', '0', 'sys_user_sex', '', '', 'Y', '0', 'openadmin', now(), '', NULL, '性别男');
INSERT INTO sys_dict_data VALUES (2, 2, '女', '1', 'sys_user_sex', '', '', 'N', '0', 'openadmin', now(), '', NULL, '性别女');
INSERT INTO sys_dict_data VALUES (3, 3, '未知', '2', 'sys_user_sex', '', '', 'N', '0', 'openadmin', now(), '', NULL, '性别未知');
INSERT INTO sys_dict_data VALUES (4, 1, '显示', '0', 'sys_show_hide', '', 'primary', 'Y', '0', 'openadmin', now(), '', NULL, '显示菜单');
INSERT INTO sys_dict_data VALUES (5, 2, '隐藏', '1', 'sys_show_hide', '', 'danger', 'N', '0', 'openadmin', now(), '', NULL, '隐藏菜单');
INSERT INTO sys_dict_data VALUES (6, 1, '正常', '0', 'sys_normal_disable', '', 'primary', 'Y', '0', 'openadmin', now(), '', NULL, '正常状态');
INSERT INTO sys_dict_data VALUES (7, 2, '停用', '1', 'sys_normal_disable', '', 'danger', 'N', '0', 'openadmin', now(), '', NULL, '停用状态');
INSERT INTO sys_dict_data VALUES (8, 1, '是', 'Y', 'sys_yes_no', '', 'primary', 'Y', '0', 'openadmin', now(), '', NULL, '系统默认是');
INSERT INTO sys_dict_data VALUES (9, 2, '否', 'N', 'sys_yes_no', '', 'danger', 'N', '0', 'openadmin', now(), '', NULL, '系统默认否');
INSERT INTO sys_dict_data VALUES (10, 1, '新增', '1', 'sys_oper_type', '', 'info', 'N', '0', 'openadmin', now(), '', NULL, '新增操作');
INSERT INTO sys_dict_data VALUES (11, 2, '修改', '2', 'sys_oper_type', '', 'info', 'N', '0', 'openadmin', now(), '', NULL, '修改操作');
INSERT INTO sys_dict_data VALUES (12, 3, '删除', '3', 'sys_oper_type', '', 'danger', 'N', '0', 'openadmin', now(), '', NULL, '删除操作');
INSERT INTO sys_dict_data VALUES (13, 4, '授权', '4', 'sys_oper_type', '', 'primary', 'N', '0', 'openadmin', now(), '', NULL, '授权操作');
INSERT INTO sys_dict_data VALUES (14, 5, '导出', '5', 'sys_oper_type', '', 'warning', 'N', '0', 'openadmin', now(), '', NULL, '导出操作');
INSERT INTO sys_dict_data VALUES (15, 6, '导入', '6', 'sys_oper_type', '', 'warning', 'N', '0', 'openadmin', now(), '', NULL, '导入操作');
INSERT INTO sys_dict_data VALUES (16, 7, '强退', '7', 'sys_oper_type', '', 'danger', 'N', '0', 'openadmin', now(), '', NULL, '强退操作');
INSERT INTO sys_dict_data VALUES (17, 8, '生成代码', '8', 'sys_oper_type', '', 'warning', 'N', '0', 'openadmin', now(), '', NULL, '生成操作');
INSERT INTO sys_dict_data VALUES (18, 9, '清空数据', '9', 'sys_oper_type', '', 'danger', 'N', '0', 'openadmin', now(), '', NULL, '清空操作');
INSERT INTO sys_dict_data VALUES (19, 1, '成功', '0', 'sys_common_status', '', 'primary', 'N', '0', 'openadmin', now(), '', NULL, '正常状态');
INSERT INTO sys_dict_data VALUES (20, 2, '失败', '1', 'sys_common_status', '', 'danger', 'N', '0', 'openadmin', now(), '', NULL, '停用状态');
INSERT INTO sys_dict_data VALUES (21, 1, '通知', '1', 'sys_notice_type', '', 'warning', 'Y', '0', 'openadmin', now(), '', NULL, '通知');
INSERT INTO sys_dict_data VALUES (22, 2, '公告', '2', 'sys_notice_type', '', 'success', 'N', '0', 'openadmin', now(), '', NULL, '公告');
INSERT INTO sys_dict_data VALUES (23, 1, '正常', '0', 'sys_notice_status', '', 'primary', 'Y', '0', 'openadmin', now(), '', NULL, '正常状态');
INSERT INTO sys_dict_data VALUES (24, 2, '关闭', '1', 'sys_notice_status', '', 'danger', 'N', '0', 'openadmin', now(), '', NULL, '关闭状态');
INSERT INTO sys_dict_data VALUES (25, 0, '其他', '0', 'sys_oper_type', NULL, 'default', 'N', '0', 'openadmin', now(), '', NULL, NULL);
INSERT INTO sys_dict_data VALUES (26, 10, '查询', '10', 'sys_oper_type', NULL, 'default', 'N', '0', 'openadmin', now(), '', NULL, NULL);
INSERT INTO sys_dict_data VALUES (27, 11, '详情', '11', 'sys_oper_type', NULL, 'default', 'N', '0', 'openadmin', now(), '', NULL, NULL);
INSERT INTO sys_dict_data VALUES (28, 12, '刷新', '12', 'sys_oper_type', NULL, 'default', 'N', '0', 'openadmin', now(), '', NULL, NULL);
INSERT INTO sys_dict_data VALUES (29, 0, 'GET', 'GET', 'sys_request_method', NULL, 'primary', 'N', '0', 'openadmin', now(), 'openadmin', NULL, NULL);
INSERT INTO sys_dict_data VALUES (30, 1, 'POST', 'POST', 'sys_request_method', NULL, 'success', 'N', '0', 'openadmin', now(), 'openadmin', NULL, NULL);
INSERT INTO sys_dict_data VALUES (31, 2, 'PUT', 'PUT', 'sys_request_method', NULL, 'warning', 'N', '0', 'openadmin', now(), 'openadmin', NULL, NULL);
INSERT INTO sys_dict_data VALUES (32, 3, 'DELETE', 'DELETE', 'sys_request_method', NULL, 'danger', 'N', '0', 'openadmin', now(), 'openadmin', NULL, NULL);
INSERT INTO sys_dict_data VALUES (33, 0, '已完成', '0', 'sys_complete_status', NULL, 'primary', 'N', '0', 'openadmin', now(), 'openadmin', NULL, '已完成');
INSERT INTO sys_dict_data VALUES (34, 1, '未完成', '1', 'sys_complete_status', NULL, 'danger', 'N', '0', 'openadmin', now(), 'openadmin', NULL, '未完成');

INSERT INTO sys_dict_type VALUES (1, '用户性别', 'sys_user_sex', '0', 'openadmin', now(), '', NULL, '用户性别列表');
INSERT INTO sys_dict_type VALUES (2, '菜单状态', 'sys_show_hide', '0', 'openadmin', now(), '', NULL, '菜单状态列表');
INSERT INTO sys_dict_type VALUES (3, '系统开关', 'sys_normal_disable', '0', 'openadmin', now(), '', NULL, '系统开关列表');
INSERT INTO sys_dict_type VALUES (4, '系统是否', 'sys_yes_no', '0', 'openadmin', now(), '', NULL, '系统是否列表');
INSERT INTO sys_dict_type VALUES (5, '操作类型', 'sys_oper_type', '0', 'openadmin', now(), '', NULL, '操作类型列表');
INSERT INTO sys_dict_type VALUES (6, '系统状态', 'sys_common_status', '0', 'openadmin', now(), '', NULL, '登录状态列表');
INSERT INTO sys_dict_type VALUES (7, '通知类型', 'sys_notice_type', '0', 'openadmin', now(), '', NULL, '通知类型列表');
INSERT INTO sys_dict_type VALUES (8, '通知状态', 'sys_notice_status', '0', 'openadmin', now(), '', NULL, '通知状态列表');
INSERT INTO sys_dict_type VALUES (9, '请求方式', 'sys_request_method', '0', 'openadmin', now(), '', NULL, 'GET/POST/PUT/DELETE等');
INSERT INTO sys_dict_type VALUES (10, '完成状态', 'sys_complete_status', '0', 'openadmin', now(), 'openadmin', NULL, '接口完成状态');

INSERT INTO sys_menu VALUES (1, '系统管理', 0, 100, 'system', NULL, '', 1, 0, 'M', '0', '0', '', 'system', 'openadmin', now(), '', NULL, '系统管理目录');
INSERT INTO sys_menu VALUES (2, '系统监控', 1, 10, 'monitor', NULL, '', 1, 0, 'M', '0', '0', '', 'monitor', 'openadmin', now(), '', NULL, '系统监控目录');
INSERT INTO sys_menu VALUES (100, '用户管理', 1, 1, 'user', 'system/user/index', '', 1, 0, 'C', '0', '0', 'system:user:list', 'user', 'openadmin', now(), '', NULL, '用户管理菜单');
INSERT INTO sys_menu VALUES (101, '角色管理', 1, 2, 'role', 'system/role/index', '', 1, 0, 'C', '0', '0', 'system:role:list', 'peoples', 'openadmin', now(), '', NULL, '角色管理菜单');
INSERT INTO sys_menu VALUES (102, '菜单管理', 1, 3, 'menu', 'system/menu/index', '', 1, 0, 'C', '0', '0', 'system:menu:list', 'tree-table', 'openadmin', now(), '', NULL, '菜单管理菜单');
INSERT INTO sys_menu VALUES (103, '部门管理', 1, 4, 'dept', 'system/dept/index', '', 1, 0, 'C', '0', '0', 'system:dept:list', 'tree', 'openadmin', now(), '', NULL, '部门管理菜单');
INSERT INTO sys_menu VALUES (104, '岗位管理', 1, 5, 'post', 'system/post/index', '', 1, 0, 'C', '0', '0', 'system:post:list', 'post', 'openadmin', now(), '', NULL, '岗位管理菜单');
INSERT INTO sys_menu VALUES (105, '字典管理', 1, 6, 'dict', 'system/dict/index', '', 1, 0, 'C', '0', '0', 'system:dict:list', 'dict', 'openadmin', now(), '', NULL, '字典管理菜单');
INSERT INTO sys_menu VALUES (106, '参数设置', 1, 7, 'config', 'system/config/index', '', 1, 0, 'C', '0', '0', 'system:config:list', 'edit', 'openadmin', now(), '', NULL, '参数设置菜单');
INSERT INTO sys_menu VALUES (107, '通知公告', 1, 8, 'notice', 'system/notice/index', '', 1, 0, 'C', '0', '0', 'system:notice:list', 'message', 'openadmin', now(), '', NULL, '通知公告菜单');
INSERT INTO sys_menu VALUES (108, '日志管理', 1, 9, 'log', '', '', 1, 0, 'M', '0', '0', '', 'log', 'openadmin', '2023-01-07 15:03:50', '', NULL, '日志管理菜单');
INSERT INTO sys_menu VALUES (109, '在线用户', 2, 1, 'online', 'system/online/index', '', 1, 0, 'C', '0', '0', 'system:online:list', 'online', 'openadmin', now(), 'openadmin', NULL, '在线用户菜单');
INSERT INTO sys_menu VALUES (112, '服务监控', 2, 2, 'server', 'system/server/index', '', 1, 0, 'C', '0', '0', 'system:server:list', 'server', 'openadmin', now(), 'openadmin', NULL, '服务监控菜单');
INSERT INTO sys_menu VALUES (113, '缓存监控', 2, 3, 'cache', 'system/cache/index', '', 1, 0, 'C', '0', '0', 'system:cache:list', 'redis', 'openadmin', now(), 'openadmin', NULL, '缓存监控菜单');
INSERT INTO sys_menu VALUES (116, '代码生成', 1, 12, 'gen', 'system/gen/index', '', 1, 0, 'C', '0', '0', 'system:gen:list', 'code', 'openadmin', now(), 'openadmin', NULL, '代码生成菜单');
INSERT INTO sys_menu VALUES (117, '接口文档', 1, 11, 'apidoc', 'system/apidoc/index', '', 1, 0, 'C', '0', '0', 'system:apidoc:list', 'documentation', 'openadmin', now(), 'openadmin', NULL, '接口文档菜单');
INSERT INTO sys_menu VALUES (500, '操作日志', 108, 1, 'operlog', 'system/operlog/index', '', 1, 0, 'C', '0', '0', 'system:operlog:list', 'form', 'openadmin', now(), '', NULL, '操作日志菜单');
INSERT INTO sys_menu VALUES (501, '登录日志', 108, 2, 'loginlog', 'system/loginlog/index', '', 1, 0, 'C', '0', '0', 'system:loginlog:list', 'logininfor', 'openadmin', now(), '', NULL, '登录日志菜单');
INSERT INTO sys_menu VALUES (1000, '用户查询', 100, 1, '', '', '', 1, 0, 'F', '0', '0', 'system:user:query', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1001, '用户新增', 100, 2, '', '', '', 1, 0, 'F', '0', '0', 'system:user:add', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1002, '用户修改', 100, 3, '', '', '', 1, 0, 'F', '0', '0', 'system:user:edit', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1003, '用户删除', 100, 4, '', '', '', 1, 0, 'F', '0', '0', 'system:user:remove', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1004, '用户导出', 100, 5, '', '', '', 1, 0, 'F', '0', '0', 'system:user:export', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1005, '用户导入', 100, 6, '', '', '', 1, 0, 'F', '0', '0', 'system:user:import', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1006, '重置密码', 100, 7, '', '', '', 1, 0, 'F', '0', '0', 'system:user:resetPwd', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1007, '角色查询', 101, 1, '', '', '', 1, 0, 'F', '0', '0', 'system:role:query', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1008, '角色新增', 101, 2, '', '', '', 1, 0, 'F', '0', '0', 'system:role:add', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1009, '角色修改', 101, 3, '', '', '', 1, 0, 'F', '0', '0', 'system:role:edit', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1010, '角色删除', 101, 4, '', '', '', 1, 0, 'F', '0', '0', 'system:role:remove', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1011, '角色导出', 101, 5, '', '', '', 1, 0, 'F', '0', '0', 'system:role:export', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1012, '菜单查询', 102, 1, '', '', '', 1, 0, 'F', '0', '0', 'system:menu:query', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1013, '菜单新增', 102, 2, '', '', '', 1, 0, 'F', '0', '0', 'system:menu:add', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1014, '菜单修改', 102, 3, '', '', '', 1, 0, 'F', '0', '0', 'system:menu:edit', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1015, '菜单删除', 102, 4, '', '', '', 1, 0, 'F', '0', '0', 'system:menu:remove', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1016, '部门查询', 103, 1, '', '', '', 1, 0, 'F', '0', '0', 'system:dept:query', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1017, '部门新增', 103, 2, '', '', '', 1, 0, 'F', '0', '0', 'system:dept:add', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1018, '部门修改', 103, 3, '', '', '', 1, 0, 'F', '0', '0', 'system:dept:edit', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1019, '部门删除', 103, 4, '', '', '', 1, 0, 'F', '0', '0', 'system:dept:remove', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1020, '岗位查询', 104, 1, '', '', '', 1, 0, 'F', '0', '0', 'system:post:query', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1021, '岗位新增', 104, 2, '', '', '', 1, 0, 'F', '0', '0', 'system:post:add', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1022, '岗位修改', 104, 3, '', '', '', 1, 0, 'F', '0', '0', 'system:post:edit', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1023, '岗位删除', 104, 4, '', '', '', 1, 0, 'F', '0', '0', 'system:post:remove', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1024, '岗位导出', 104, 5, '', '', '', 1, 0, 'F', '0', '0', 'system:post:export', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1025, '字典查询', 105, 1, '#', '', '', 1, 0, 'F', '0', '0', 'system:dict:query', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1026, '字典新增', 105, 2, '#', '', '', 1, 0, 'F', '0', '0', 'system:dict:add', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1027, '字典修改', 105, 3, '#', '', '', 1, 0, 'F', '0', '0', 'system:dict:edit', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1028, '字典删除', 105, 4, '#', '', '', 1, 0, 'F', '0', '0', 'system:dict:remove', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1029, '字典导出', 105, 5, '#', '', '', 1, 0, 'F', '0', '0', 'system:dict:export', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1030, '参数查询', 106, 1, '#', '', '', 1, 0, 'F', '0', '0', 'system:config:query', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1031, '参数新增', 106, 2, '#', '', '', 1, 0, 'F', '0', '0', 'system:config:add', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1032, '参数修改', 106, 3, '#', '', '', 1, 0, 'F', '0', '0', 'system:config:edit', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1033, '参数删除', 106, 4, '#', '', '', 1, 0, 'F', '0', '0', 'system:config:remove', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1034, '参数导出', 106, 5, '#', '', '', 1, 0, 'F', '0', '0', 'system:config:export', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1035, '公告查询', 107, 1, '#', '', '', 1, 0, 'F', '0', '0', 'system:notice:query', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1036, '公告新增', 107, 2, '#', '', '', 1, 0, 'F', '0', '0', 'system:notice:add', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1037, '公告修改', 107, 3, '#', '', '', 1, 0, 'F', '0', '0', 'system:notice:edit', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1038, '公告删除', 107, 4, '#', '', '', 1, 0, 'F', '0', '0', 'system:notice:remove', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1039, '操作查询', 500, 1, '#', '', '', 1, 0, 'F', '0', '0', 'system:operlog:query', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1040, '操作删除', 500, 2, '#', '', '', 1, 0, 'F', '0', '0', 'system:operlog:remove', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1041, '日志导出', 500, 3, '#', '', '', 1, 0, 'F', '0', '0', 'system:operlog:export', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1042, '登录查询', 501, 1, '#', '', '', 1, 0, 'F', '0', '0', 'system:loginlog:query', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1043, '登录删除', 501, 2, '#', '', '', 1, 0, 'F', '0', '0', 'system:loginlog:remove', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1044, '日志导出', 501, 3, '#', '', '', 1, 0, 'F', '0', '0', 'system:loginlog:export', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1045, '账户解锁', 501, 4, '#', '', '', 1, 0, 'F', '0', '0', 'system:loginlog:unlock', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1046, '在线查询', 109, 1, '#', '', '', 1, 0, 'F', '0', '0', 'system:online:query', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1047, '批量强退', 109, 2, '#', '', '', 1, 0, 'F', '0', '0', 'system:online:batchLogout', '#', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_menu VALUES (1048, '单条强退', 109, 3, '#', '', '', 1, 0, 'F', '0', '0', 'system:online:forceLogout', '#', 'openadmin', now(), '', NULL, '');

INSERT INTO sys_notice VALUES (1, '温馨提醒：2022-12-19 0.0.1版本发布啦', '2', 'open-admin-0.0.1版本发布', '0', 'openadmin', now(), '', NULL, '管理员');

INSERT INTO sys_post VALUES (1, 'ceo', '总经理', 1, '0', 'openadmin', now(), '', NULL, '');
INSERT INTO sys_post VALUES (2, 'prj', '项目经理', 2, '0', 'openadmin', now(), 'openadmin', NULL, '');

INSERT INTO sys_role VALUES (1, '超级管理员', 'openadmin', 1, 1, 1, '0', '0', 'openadmin', now(), '', NULL, '超级管理员');

INSERT INTO sys_user VALUES (1, 1, 'openadmin', 'openadmin', '00', 'openadmin@morethank.cn', '15888888880', '1', NULL, '$2a$10$UWJIisonaKgjBzOP0Zr34eeeUIwWoLSEI6mQEgTvAwUCMGQSHOZy2', '0', '0', '127.0.0.1', NULL, 'openadmin', now(), NULL, NULL, '管理员');
