<template>
   <div class="app-container">
      <el-form :model="queryParams" ref="queryRef" :inline="true" v-show="showSearch" label-width="68px">
<#list columns as column>
<#if column.isQuery?? && column.isQuery == "1">
<#assign dictType = column.dictType>
<#assign parentheseIndex = column.columnComment?index_of("（")>
<#if parentheseIndex != -1>
<#assign colComment = column.columnComment?substring(0, parentheseIndex)>
<#else>
<#assign colComment = column.columnComment>
</#if>
<#if column.htmlType??>
<#if column.htmlType == "input">
         <el-form-item label="${colComment}" prop="${column.javaField}">
            <el-input v-model="queryParams.${column.javaField}" placeholder="请输入${colComment}" clearable @keyup.enter="handleQuery" />
         </el-form-item>
<#elseif (column.htmlType == "select" || column.htmlType == "radio") && "" != dictType>
         <el-form-item label="${colComment}" prop="${column.javaField}">
            <el-select v-model="queryParams.${column.javaField}" placeholder="请选择${colComment}" clearable>
               <el-option v-for="dict in ${dictType}" :key="dict.value" :label="dict.label" :value="dict.value" />
            </el-select>
         </el-form-item>
<#elseif (column.htmlType == "select" || column.htmlType == "radio") && dictType??>
         <el-form-item label="${colComment}" prop="${column.javaField}">
            <el-select v-model="queryParams.${column.javaField}" placeholder="请选择${colComment}" clearable>
               <el-option label="请选择字典生成" value="" />
            </el-select>
         </el-form-item>
<#elseif column.htmlType == "datetime" && column.queryType?? && column.queryType == "BETWEEN">
         <el-form-item label="${colComment}" style="width: 308px">
            <el-date-picker
               v-model="daterange${column.javaField?cap_first}"
               value-format="YYYY-MM-DD"
               type="daterange"
               range-separator="-"
               start-placeholder="开始日期"
               end-placeholder="结束日期"
            ></el-date-picker>
         </el-form-item>
<#elseif column.htmlType == "datetime">
         <el-form-item label="${colComment}" prop="${column.javaField}">
            <el-date-picker clearable
               v-model="queryParams.${column.javaField}"
               type="date"
               value-format="YYYY-MM-DD"
               placeholder="请选择${colComment}">
            </el-date-picker>
         </el-form-item>
</#if><#-- column.htmlType -->
</#if><#-- column.htmlType?? -->
</#if><#-- column.isQuery -->
</#list><#-- columns -->
         <el-form-item>
            <el-button type="primary" icon="Search" @click="handleQuery">搜索</el-button>
            <el-button icon="Refresh" @click="resetQuery">重置</el-button>
         </el-form-item>
      </el-form>

      <el-row :gutter="10" class="mb8">
         <el-col :span="1.5">
            <el-button type="primary" plain icon="Plus" @click="handleAdd" v-hasPermi="['${moduleName}:${businessName}:add']" >新增</el-button>
         </el-col>
         <el-col :span="1.5">
            <el-button type="success" plain icon="Edit" :disabled="single" @click="handleUpdate" v-hasPermi="['${moduleName}:${businessName}:edit']" >修改</el-button>
         </el-col>
         <el-col :span="1.5">
            <el-button type="danger" plain icon="Delete" :disabled="multiple" @click="handleDelete" v-hasPermi="['${moduleName}:${businessName}:remove']" >删除</el-button>
         </el-col>
         <el-col :span="1.5">
            <el-button type="warning" plain icon="Download" @click="handleExport" v-hasPermi="['${moduleName}:${businessName}:export']" >导出</el-button>
         </el-col>
         <right-toolbar v-model:showSearch="showSearch" @queryTable="getList"></right-toolbar>
      </el-row>

      <el-table v-loading="loading" :data="postList" @selection-change="handleSelectionChange">
         <el-table-column type="selection" width="55" align="center" />
<#list columns as column>
<#assign parentheseIndex = column.columnComment?index_of("（")>
<#if parentheseIndex != -1>
<#assign colComment = column.columnComment?substring(0, parentheseIndex)>
<#else>
<#assign colComment = column.columnComment>
</#if>
<#if column.pk>
         <el-table-column label="${colComment}" align="center" prop="${column.javaField}" />
<#elseif column.list && column.htmlType?? && column.htmlType == "datetime">
         <el-table-column label="${colComment}" align="center" prop="${column.javaField}" width="180">
            <template #default="scope">
               <span>{{ parseTime(scope.row.${column.javaField}, '{y}-{m}-{d}') }}</span>
            </template>
         </el-table-column>
<#elseif column.list && column.htmlType?? && column.htmlType == "imageUpload">
         <el-table-column label="${colComment}" align="center" prop="${column.javaField}" width="100">
            <template #default="scope">
               <image-preview :src="scope.row.${column.javaField}" :width="50" :height="50"/>
            </template>
         </el-table-column>
<#elseif column.list && "" != column.dictType>
         <el-table-column label="${colComment}" align="center" prop="${column.javaField}">
            <template #default="scope">
<#if column.htmlType?? && column.htmlType == "checkbox">
               <dict-tag :options="${column.dictType}" :value="scope.row.${column.javaField} ? scope.row.${column.javaField}.split(',') : []"/>
<#else>
               <dict-tag :options="${column.dictType}" :value="scope.row.${column.javaField}"/>
</#if>
            </template>
         </el-table-column>
<#elseif column.list && "" != column.javaField>
         <el-table-column label="${colComment}" align="center" prop="${column.javaField}" />
</#if>
</#list>
         <el-table-column label="操作" align="center" class-name="small-padding fixed-width">
            <template #default="scope">
               <el-button type="text" icon="Edit" @click="handleUpdate(scope.row)" v-hasPermi="['${moduleName}:${businessName}:edit']" >修改</el-button>
               <el-button type="text" icon="Delete" @click="handleDelete(scope.row)" v-hasPermi="['${moduleName}:${businessName}:remove']" >删除</el-button>
            </template>
         </el-table-column>
      </el-table>

      <pagination v-show="total > 0" :total="total" v-model:page="queryParams.pageNum" v-model:limit="queryParams.pageSize" @pagination="getList" />

      <!-- 添加或修改${functionName}对话框 -->
      <el-dialog :title="title" v-model="open" width="500px" append-to-body>
         <el-form ref="${businessName}Ref" :model="form" :rules="rules" label-width="80px">
<#list columns as column>
<#if column.isInsert == '1' && !column.pk>
<#if column.usableColumn || !column.superColumn>
<#if parentheseIndex != -1>
<#assign colComment = column.columnComment?substring(0, parentheseIndex)>
<#else>
<#assign colComment = column.columnComment>
</#if>
<#if column.htmlType?? && column.htmlType == "input">
            <el-form-item label="${colComment}" prop="${column.javaField}">
               <el-input v-model="form.${column.javaField}" placeholder="请输入${colComment}" />
            </el-form-item>
<#elseif column.htmlType?? && column.htmlType == "imageUpload">
            <el-form-item label="${colComment}" prop="${column.javaField}">
               <image-upload v-model="form.${column.javaField}"/>
            </el-form-item>
<#elseif column.htmlType?? && column.htmlType == "fileUpload">
            <el-form-item label="${colComment}" prop="${column.javaField}">
               <file-upload v-model="form.${column.javaField}"/>
            </el-form-item>
<#elseif column.htmlType?? && column.htmlType == "editor">
            <el-form-item label="${colComment}">
               <editor v-model="form.${column.javaField}" :min-height="192"/>
            </el-form-item>
<#elseif column.htmlType?? && column.htmlType == "select" && "" != dictType>
            <el-form-item label="${colComment}" prop="${column.javaField}">
               <el-select v-model="form.${column.javaField}" placeholder="请选择${colComment}">
                  <el-option
                     v-for="dict in ${dictType}"
                     :key="dict.value"
                     :label="dict.label"
<#if column.javaType == "Integer" || column.javaType == "Long">
                     :value="parseInt(dict.value)"
<#else>
                     :value="dict.value"
</#if>
                  ></el-option>
               </el-select>
            </el-form-item>
<#elseif column.htmlType?? && column.htmlType == "select" && dictType>
            <el-form-item label="${colComment}" prop="${column.javaField}">
               <el-select v-model="form.${column.javaField}" placeholder="请选择${colComment}">
                  <el-option label="请选择字典生成" value="" />
               </el-select>
            </el-form-item>
<#elseif column.htmlType?? && column.htmlType == "checkbox" && "" != dictType>
            <el-form-item label="${colComment}" prop="${column.javaField}">
               <el-checkbox-group v-model="form.${column.javaField}">
                  <el-checkbox v-for="dict in ${dictType}" :key="dict.value" :label="dict.value">{{dict.label}}</el-checkbox>
               </el-checkbox-group>
            </el-form-item>
<#elseif column.htmlType?? && column.htmlType == "checkbox" && dictType>
            <el-form-item label="${colComment}" prop="${column.javaField}">
               <el-checkbox-group v-model="form.${column.javaField}">
                  <el-checkbox>请选择字典生成</el-checkbox>
               </el-checkbox-group>
            </el-form-item>
<#elseif column.htmlType?? && column.htmlType == "radio" && "" != dictType>
            <el-form-item label="${colComment}" prop="${column.javaField}">
               <el-radio-group v-model="form.${column.javaField}">
                  <el-radio
                     v-for="dict in ${dictType}"
                     :key="dict.value"
<#if column.javaType == "Integer" || column.javaType == "Long">
                     :label="parseInt(dict.value)"
<#else>
                     :label="dict.value"
</#if>
                  >{{dict.label}}</el-radio>
               </el-radio-group>
            </el-form-item>
<#elseif column.htmlType?? && column.htmlType == "radio" && dictType>
            <el-form-item label="${colComment}" prop="${column.javaField}">
               <el-radio-group v-model="form.${column.javaField}">
                  <el-radio label="1">请选择字典生成</el-radio>
               </el-radio-group>
            </el-form-item>
<#elseif column.htmlType?? && column.htmlType == "datetime">
            <el-form-item label="${colComment}" prop="${column.javaField}">
               <el-date-picker clearable
                  v-model="form.${column.javaField}"
                  type="date"
                  value-format="YYYY-MM-DD"
                  placeholder="请选择${colComment}">
               </el-date-picker>
            </el-form-item>
<#elseif column.htmlType?? && column.htmlType == "textarea">
            <el-form-item label="${colComment}" prop="${column.javaField}">
               <el-input v-model="form.${column.javaField}" type="textarea" placeholder="请输入内容" />
            </el-form-item>
</#if>
</#if>
</#if>
</#list>
         </el-form>
         <template #footer>
            <div class="dialog-footer">
               <el-button type="primary" @click="submitForm">确 定</el-button>
               <el-button @click="cancel">取 消</el-button>
            </div>
         </template>
      </el-dialog>
   </div>
</template>

<script setup name="${BusinessName}">
import { list${BusinessName}, get${BusinessName}, add${BusinessName}, update${BusinessName}, del${BusinessName} } from "@/api/${moduleName}/${businessName}";

const { proxy } = getCurrentInstance();
<#if dicts?? && dicts != "">
<#assign dictsNoSymbol = dictsNoSymbol?replace("'", "")>
const { ${dictsNoSymbol} } = proxy.useDict(${dicts});
</#if>

const ${businessName}List = ref([]);
const open = ref(false);
const loading = ref(true);
const showSearch = ref(true);
const ids = ref([]);
const single = ref(true);
const multiple = ref(true);
const total = ref(0);
const title = ref("");

const data = reactive({
  form: {},
  queryParams: {
    pageNum: 1,
    pageSize: 10,
<#assign index = 0>
<#list columns as column>
<#if column.isRequired?? && column.isRequired == "1">
    ${column.javaField}: null<#if index != 0>,</#if><#assign index = index+1>
</#if>
</#list>
  },
  rules: {
<#assign index = 0>
<#list columns as column>
<#if column.isRequired?? && column.isRequired == "1">
<#assign parentheseIndex = column.columnComment?index_of("（")>
<#if parentheseIndex != -1>
<#assign colComment = column.columnComment?substring(0, parentheseIndex)>
<#else>
<#assign colComment = column.columnComment>
</#if>
    ${column.javaField}: [{ required: true, message: "${colComment}不能为空", trigger: <#if column.htmlType?? && (column.htmlType == "select" || column.htmlType == "radio")>"change"<#else>"blur"</#if> }]<#if index != 0>,</#if><#assign index = index+1>
</#if>
</#list>
  }
});

const { queryParams, form, rules } = toRefs(data);

/** 查询岗位列表 */
function getList() {
  loading.value = true;
  list${BusinessName}(queryParams.value).then(response => {
    ${businessName}List.value = response.data.records;
    total.value = response.data.total;
    loading.value = false;
  });
}
/** 取消按钮 */
function cancel() {
  open.value = false;
  reset();
}
/** 表单重置 */
function reset() {
  form.value = {
<#assign index = 0>
<#list columns as column>
<#if column.htmlType?? && column.htmlType == "checkbox">
    ${column.javaField}: []<#if index != 0>,</#if>
<#else>
    ${column.javaField}: null<#if index != 0>,</#if>
</#if>
<#assign index = index+1>
</#list>
  };
  proxy.resetForm("${businessName}Ref");
}
/** 搜索按钮操作 */
function handleQuery() {
  queryParams.value.pageNum = 1;
  getList();
}
/** 重置按钮操作 */
function resetQuery() {
<#list columns as column>
<#if column.htmlType?? && column.htmlType == "datetime" && column.queryType == "BETWEEN">
  daterange${column.javaField?cap_first}.value = [];
</#if>
</#list>
  proxy.resetForm("queryRef");
  handleQuery();
}
/** 多选框选中数据 */
function handleSelectionChange(selection) {
  ids.value = selection.map(item => item.${pkColumn.javaField});
  single.value = selection.length != 1;
  multiple.value = !selection.length;
}
/** 新增按钮操作 */
function handleAdd() {
  reset();
  open.value = true;
  title.value = "添加${functionName}";
}
/** 修改按钮操作 */
function handleUpdate(row) {
  reset();
  const ${pkColumn.javaField} = row.${pkColumn.javaField} || ids.value;
  get${BusinessName}(${pkColumn.javaField}).then(response => {
    form.value = response.data;
    open.value = true;
    title.value = "修改${functionName}";
  });
}
/** 提交按钮 */
function submitForm() {
  proxy.$refs["${businessName}Ref"].validate(valid => {
    if (valid) {
<#list columns as column>
<#if column.htmlType?? && column.htmlType == "checkbox">
       form.value.${column}.javaField = form.value.${column.javaField}.join(",");
</#if>
</#list>
      if (form.value.${pkColumn.javaField} != undefined) {
        update${BusinessName}(form.value).then(response => {
          proxy.$modal.msgSuccess("修改成功");
          open.value = false;
          getList();
        });
      } else {
        add${BusinessName}(form.value).then(response => {
          proxy.$modal.msgSuccess("新增成功");
          open.value = false;
          getList();
        });
      }
    }
  });
}
/** 删除按钮操作 */
function handleDelete(row) {
  const ${pkColumn.javaField}s = row.${pkColumn.javaField} || ids.value;
  proxy.$modal.confirm('是否确认删除${functionName}编号为"' + ${pkColumn.javaField}s + '"的数据项？').then(function() {
    return del${BusinessName}(${pkColumn.javaField}s);
  }).then(() => {
    getList();
    proxy.$modal.msgSuccess("删除成功");
  }).catch(() => {});
}
/** 导出按钮操作 */
function handleExport() {
  proxy.download("${moduleName}/${businessName}/export", {
    ...queryParams.value
  }, `${businessName}_${r"${new Date().getTime()}"}.xlsx`);
}

getList();
</script>
