package ${packageName}.domain;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

/**
 * ${functionName}对象 ${tableName}
 * 
 * @author ${author}
 * @date ${datetime}
 */
@ExcelIgnoreUnannotated
@Data
@TableName("${tableName}")
public class ${ClassName} implements Serializable {
    private static final long serialVersionUID = 1L;

<#list columns as column>
    /**
     * ${column.columnComment}
     */
<#if column.export?? && column.export>
    @ExcelProperty("${column.columnComment}")
</#if>
<#if column.pk?? && column.pk>
    <#if column.isIncrement?? && column.isIncrement == "1">
    @TableId(value = "${column.columnName}", type = IdType.AUTO)
    <#else>
    @TableId(value = "${column.columnName}", type = IdType.ASSIGN_ID)
    </#if>
<#else>
    <#if column.javaType == "java.time.LocalDateTime" >
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    </#if>
    <#if column.javaType == "java.time.LocalDate" >
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    </#if>
    @TableField("${column.columnName}")
</#if>
    private ${column.javaType} ${column.javaField};

</#list>
}
