package ${packageName}.controller;

import javax.servlet.http.HttpServletResponse;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.List;

import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import ${packageName}.service.${ClassName}Service;
import ${packageName}.domain.${ClassName};
import cn.morethank.open.admin.common.annotation.OperateLog;
import cn.morethank.open.admin.common.domain.BusinessType;
import cn.morethank.open.admin.common.domain.Result;
import cn.morethank.open.admin.common.service.JwtService;
import com.alibaba.excel.EasyExcel;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.*;

/**
 * ${functionName}
 * 前端控制器
 *
 * @author ${author}
 * @since ${datetime}
 */
@Slf4j
@AllArgsConstructor
@RestController
@RequestMapping("/${moduleName}/${businessName}")
public class ${ClassName}Controller {

    private final ${ClassName}Service ${ClassName?uncap_first}Service;
    private final JwtService jwtService;

    /**
     * 详情页
     */
    @OperateLog(title = "${functionName}", businessType = BusinessType.DETAIL)
    @PreAuthorize("@auth.hasAuthority('${permissionPrefix}:query')")
    @GetMapping("{id}")
    public Result<${ClassName}> detail(@PathVariable Integer id) {
        ${ClassName} ${ClassName?uncap_first} = ${ClassName?uncap_first}Service.getById(id);
        return Result.success(${ClassName?uncap_first});
    }

    /**
     * 分页查询
     *
     * @param ${ClassName?uncap_first}    分页查询筛选条件
     * @param pageNo   页码
     * @param pageSize 每页的数量
     * @return 分页查询结果
     */
    @OperateLog(title = "${functionName}", businessType = BusinessType.LIST)
    @PreAuthorize("@auth.hasAuthority('${permissionPrefix}:list')")
    @GetMapping(value = "/list")
    public Result<IPage<${ClassName}>> list(${ClassName} ${ClassName?uncap_first},
                                 @RequestParam(name = "pageNum", defaultValue = "1") Integer pageNo,
                                 @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize) {
        log.info("分页查询${ClassName?uncap_first},检索参数${ClassName?uncap_first}={},分页参数pageNo={},pageSize={}",${ClassName?uncap_first}, pageNo, pageSize);
        try {
            // 构造分页查询条件
            LambdaQueryWrapper<${ClassName}> query = getQueryWrapper(${ClassName?uncap_first});
            IPage<${ClassName}> pageList = ${ClassName?uncap_first}Service.selectListPage(new Page<>(pageNo, pageSize), query);
            log.info("返回查询结果:{}", pageList);
            return Result.success(pageList);
        } catch (Exception e) {
            log.error("分页查询异常", e);
            return null;
        }
    }

    /**
     * 新增保存
     */
    @OperateLog(title = "${functionName}", businessType = BusinessType.INSERT)
    @PreAuthorize("@auth.hasAuthority('${permissionPrefix}:add')")
    @PostMapping
    public Result add(@Validated @RequestBody${ClassName} ${ClassName?uncap_first}) {
        /*if (${ClassName?uncap_first}Service.checkNameUnique(${ClassName?uncap_first})) {
            return Result.fail("新增${functionName}'" + ${ClassName?uncap_first}.getName() + "'失败，${functionName}已存在");
        }*/
        ${ClassName?uncap_first}.setCreateBy(jwtService.getUserName());
        ${ClassName?uncap_first}.setCreateTime(LocalDateTime.now());
        return Result.success(${ClassName?uncap_first}Service.save(${ClassName?uncap_first}));
    }

    /**
     * 修改保存
     */
    @OperateLog(title = "${functionName}", businessType = BusinessType.UPDATE)
    @PreAuthorize("@auth.hasAuthority('${permissionPrefix}:edit')")
    @PutMapping
    public Result edit(@Validated @RequestBody${ClassName} ${ClassName?uncap_first}) {
        /*if (${ClassName?uncap_first}Service.checkNameUnique(${ClassName?uncap_first})) {
            return Result.fail("修改${functionName}'" + ${ClassName?uncap_first}.getName() + "'失败，${functionName}已存在");
        }*/
        ${ClassName?uncap_first}.setUpdateBy(jwtService.getUserName());
        ${ClassName?uncap_first}.setUpdateTime(LocalDateTime.now());

        return Result.success(${ClassName?uncap_first}Service.updateById(${ClassName?uncap_first}));
    }

    /**
     * 删除接口
     */
    @OperateLog(title = "${functionName}", businessType = BusinessType.DELETE)
    @PreAuthorize("@auth.hasAuthority('${permissionPrefix}:remove')")
    @DeleteMapping("/{ids}")
    public Result remove(@PathVariable Long[] ids) {
        return Result.success(${ClassName?uncap_first}Service.deleteByIds(ids));
    }

    /**
     * 导出接口
     */
    @OperateLog(title = "${functionName}", businessType = BusinessType.EXPORT)
    @PreAuthorize("@auth.hasAuthority('${permissionPrefix}:export')")
    @PostMapping("/export")
    public void export(HttpServletResponse response, ${ClassName} ${ClassName?uncap_first}) throws Exception {
        LambdaQueryWrapper<${ClassName}> query = getQueryWrapper(${ClassName?uncap_first});
        List<${ClassName}> list = ${ClassName?uncap_first}Service.list(query);

        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        // 这里URLEncoder.encode可以防止中文乱码 当然和easyexcel没有关系
        String fileName = URLEncoder.encode("${functionName}", "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
        EasyExcel.write(response.getOutputStream(), ${ClassName}.class).sheet("${functionName}").doWrite(list);
    }

    private LambdaQueryWrapper<${ClassName}> getQueryWrapper(${ClassName} ${ClassName?uncap_first}) {
        LambdaQueryWrapper<${ClassName}> query = new LambdaQueryWrapper<>();
        // TODO 添加条件
        /*if (StrUtil.isNotEmpty(${ClassName?uncap_first}.getName())) {
            query.like(${ClassName}::getName, ${ClassName?uncap_first}.getName());
        }*/
        return query;
    }
}
