package cn.morethank.open.admin.system.service.impl;

import cn.morethank.open.admin.common.domain.LoginAccount;
import cn.morethank.open.admin.common.util.StringUtils;
import cn.morethank.open.admin.system.domain.SysUserOnline;
import cn.morethank.open.admin.system.service.SysUserOnlineService;
import org.springframework.stereotype.Service;

/**
 * @author morethank
 * @since 2022/12/17 17:23
 */
@Service
public class SysUserOnlineServiceImpl implements SysUserOnlineService {
    @Override
    public SysUserOnline selectOnlineByInfo(String ipaddr, String userName, LoginAccount user) {
        if (user.getIpaddr().contains(ipaddr) && user.getUsername().contains(userName)) {
            return loginUserToUserOnline(user);
        }
        return null;
    }

    @Override
    public SysUserOnline loginUserToUserOnline(LoginAccount user) {
        if (StringUtils.isNull(user) || StringUtils.isNull(user.getUser())) {
            return null;
        }
        SysUserOnline sysUserOnline = new SysUserOnline();
        sysUserOnline.setTokenId(user.getToken());
        sysUserOnline.setUserName(user.getUsername());
        sysUserOnline.setIpaddr(user.getIpaddr());
        sysUserOnline.setLoginLocation(user.getLoginLocation());
        sysUserOnline.setBrowser(user.getBrowser());
        sysUserOnline.setOs(user.getOs());
        sysUserOnline.setLoginTime(user.getLoginTime());
        if (StringUtils.isNotNull(user.getUser().getDept())) {
            sysUserOnline.setDeptName(user.getUser().getDept().getDeptName());
        }
        return sysUserOnline;
    }

    @Override
    public SysUserOnline selectOnlineByIpaddr(String ipaddr, LoginAccount user) {
        if (user.getIpaddr().contains(ipaddr)) {
            return loginUserToUserOnline(user);
        }
        return null;
    }

    @Override
    public SysUserOnline selectOnlineByUserName(String userName, LoginAccount user) {
        if (user.getUsername().contains(userName)) {
            return loginUserToUserOnline(user);
        }
        return null;
    }
}
