package cn.morethank.open.admin.system.service.impl;

import cn.morethank.open.admin.common.exception.ServiceException;
import cn.morethank.open.admin.system.domain.SysPost;
import cn.morethank.open.admin.system.mapper.SysPostMapper;
import cn.morethank.open.admin.system.mapper.SysUserPostMapper;
import cn.morethank.open.admin.system.service.SysPostService;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 岗位信息表 服务实现类
 *
 * @author morethank
 * @since 2022/12/17 17:23
 */
@AllArgsConstructor
@Service
public class SysPostServiceImpl extends ServiceImpl<SysPostMapper, SysPost> implements SysPostService {

    private final SysPostMapper sysPostMapper;
    private final SysUserPostMapper sysUserPostMapper;

    @Override
    public IPage<SysPost> selectListPage(Page<SysPost> page, LambdaQueryWrapper<SysPost> query) {
        return sysPostMapper.selectPage(page, query);
    }

    @Override
    public int deletePostByIds(Long[] postIds) {
        for (Long postId : postIds) {
            SysPost post = getById(postId);
            if (countUserPostById(postId) > 0) {
                throw new ServiceException(String.format("%1$s已分配,不能删除", post.getPostName()));
            }
        }
        return sysPostMapper.deletePostByIds(postIds);
    }

    /**
     * 通过岗位ID查询岗位使用数量
     *
     * @param postId 岗位ID
     * @return 结果
     */
    @Override
    public int countUserPostById(Long postId) {
        return sysUserPostMapper.countUserPostById(postId);
    }

    @Override
    public boolean checkPostNameUnique(SysPost post) {
        LambdaQueryWrapper<SysPost> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SysPost::getPostName, post.getPostName());
        if(post.getPostId() != null && post.getPostId() > 0L) {
            wrapper.ne(SysPost::getPostId, post.getPostId());
        }
        long count = sysPostMapper.selectCount(wrapper);
        return count > 0;
    }

    @Override
    public boolean checkPostCodeUnique(SysPost post) {
        LambdaQueryWrapper<SysPost> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SysPost::getPostCode, post.getPostCode());
        if(post.getPostId() != null && post.getPostId() > 0L) {
            wrapper.ne(SysPost::getPostId, post.getPostId());
        }
        long count = sysPostMapper.selectCount(wrapper);
        return count > 0;
    }

    @Override
    public List<Long> selectPostListByUserId(Long userId) {
        return sysPostMapper.selectPostListByUserId(userId);
    }
}
