package cn.morethank.open.admin.system.service.impl;

import cn.morethank.open.admin.system.domain.SysOperLog;
import cn.morethank.open.admin.system.mapper.SysOperLogMapper;
import cn.morethank.open.admin.system.service.SysOperLogService;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;
import lombok.AllArgsConstructor;

/**
 * 操作日志记录 服务实现类
 *
 * @author morethank
 * @since 2022/12/17 17:23
 */
@AllArgsConstructor
@Service
public class SysOperLogServiceImpl extends ServiceImpl<SysOperLogMapper, SysOperLog> implements SysOperLogService {

    private final SysOperLogMapper sysOperLogMapper;

    @Override
    public IPage<SysOperLog> selectListPage(Page<SysOperLog> page, LambdaQueryWrapper<SysOperLog> query) {
        return sysOperLogMapper.selectPage(page, query);
    }

    @Override
    public void cleanOperLog() {
        sysOperLogMapper.cleanOperLog();
    }
}
