package cn.morethank.open.admin.system.service.impl;

import cn.morethank.open.admin.system.domain.SysNotice;
import cn.morethank.open.admin.system.mapper.SysNoticeMapper;
import cn.morethank.open.admin.system.service.SysNoticeService;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;
import lombok.AllArgsConstructor;

import java.util.ArrayList;
import java.util.Collections;

/**
 * 通知公告表 服务实现类
 *
 * @author morethank
 * @since 2022/12/17 17:23
 */
@AllArgsConstructor
@Service
public class SysNoticeServiceImpl extends ServiceImpl<SysNoticeMapper, SysNotice> implements SysNoticeService {

    private final SysNoticeMapper sysNoticeMapper;

    @Override
    public IPage<SysNotice> selectListPage(Page<SysNotice> page, LambdaQueryWrapper<SysNotice> query) {
        return sysNoticeMapper.selectPage(page, query);
    }

    @Override
    public int deleteNoticeByIds(Long[] noticeIds) {
        ArrayList<Long> arrayList = new ArrayList<>(noticeIds.length);
		Collections.addAll(arrayList, noticeIds);
        this.removeByIds(arrayList);
        return noticeIds.length;
    }
}
