package cn.morethank.open.admin.system.service.impl;

import cn.morethank.open.admin.system.domain.SysLoginLog;
import cn.morethank.open.admin.system.mapper.SysLoginLogMapper;
import cn.morethank.open.admin.system.service.SysLoginLogService;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;
import lombok.AllArgsConstructor;

/**
 * 系统访问记录 服务实现类
 *
 * @author morethank
 * @since 2022/12/17 17:23
 */
@AllArgsConstructor
@Service
public class SysLoginLogServiceImpl extends ServiceImpl<SysLoginLogMapper, SysLoginLog> implements SysLoginLogService {

    private final SysLoginLogMapper sysLoginLogMapper;

    @Override
    public IPage<SysLoginLog> selectListPage(Page<SysLoginLog> page, LambdaQueryWrapper<SysLoginLog> query) {
        return sysLoginLogMapper.selectPage(page, query);
    }

    @Override
    public void cleanLoginLog() {
        sysLoginLogMapper.cleanLoginLog();
    }

    @Override
    public void saveLog(SysLoginLog loginLog) {
        this.save(loginLog);
    }
}
