package cn.morethank.open.admin.system.service.impl;

import cn.morethank.open.admin.common.util.StringUtils;
import cn.morethank.open.admin.system.domain.SysGenColumn;
import cn.morethank.open.admin.system.mapper.SysGenColumnMapper;
import cn.morethank.open.admin.system.service.SysGenColumnService;
import cn.morethank.open.admin.common.util.GenUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * 代码生成业务字段 服务实现类
 *
 * @author morethank
 * @since 2023-01-08 00:30:18
 */
@AllArgsConstructor
@Service
public class SysGenColumnServiceImpl extends ServiceImpl<SysGenColumnMapper, SysGenColumn> implements SysGenColumnService {

    private final SysGenColumnMapper sysGenColumnMapper;

    @Override
    public IPage<SysGenColumn> selectListPage(Page<SysGenColumn> page, LambdaQueryWrapper<SysGenColumn> query) {
        return sysGenColumnMapper.selectPage(page, query);
    }

    @Override
    public int deleteByIds(Long[] ids) {
        ArrayList<Long> arrayList = new ArrayList<>(ids.length);
		Collections.addAll(arrayList, ids);
        this.removeByIds(arrayList);
        return ids.length;
    }

    @Override
    public List<SysGenColumn> selectGenColumnListByTableId(Long id) {
        return sysGenColumnMapper.selectGenColumnListByTableId(id);
    }

    @Override
    public void genColumnListByTableName(Long tableId, String tableName) {
        List<Map<String, Object>> tableColumns = sysGenColumnMapper.getTableColumns(tableName);
        List<SysGenColumn> columns = new ArrayList<>(tableColumns.size());
        for (Map<String, Object> tableMap: tableColumns) {
            SysGenColumn column = new SysGenColumn();
            column.setTableId(tableId);
            String columnName = (String) tableMap.get("column_name");
            column.setColumnName(columnName);
            String required = (String) tableMap.get("is_required");
            column.setIsRequired(required);
            column.setIsPk((String)tableMap.get("is_pk"));
            column.setSort(Integer.parseInt(tableMap.get("sort")+""));
            column.setColumnComment((String) tableMap.get("column_comment"));
            column.setIsIncrement((String) tableMap.get("is_increment"));
            String dbType = (String) tableMap.get("data_type");
            column.setColumnType(dbType);
            column.setJavaType(GenUtils.dbType2JavaType(dbType));
            column.setJavaField(StringUtils.toCamelCase(columnName));
            String insert = ("1".equals(required) || "int".equals(dbType) || ("varchar".equals(dbType) && !columnName.endsWith("_by"))) ? "1" : "0";
            column.setIsInsert(insert);
            column.setIsEdit(insert);
            column.setIsList(insert);
            String query = "varchar".equals(dbType) && !"remark".equals(columnName) && !columnName.endsWith("_by") ? "1" : "0";
            column.setIsQuery(query);
            column.setQueryType("1".equals(query) && "varchar".equals(dbType) ? "LIKE" : "EQ");
            String htmlType = null;
            if("1".equals(insert)) {
                if ("varchar".equals(dbType)) {
                    htmlType = "input";
                } else if ("tinyint".equals(dbType) || "char".equals(dbType)) {
                    htmlType = "radio";
                } else if ("remark".equals(columnName)) {
                    htmlType = "textarea";
                }
            }
            column.setHtmlType(htmlType);
            columns.add(column);
        }
        sysGenColumnMapper.batchInsertTable(columns);
    }

}
