package cn.morethank.open.admin.system.service.impl;

import cn.morethank.open.admin.common.service.DictService;
import cn.morethank.open.admin.system.domain.SysDictData;
import cn.morethank.open.admin.system.mapper.SysDictDataMapper;
import cn.morethank.open.admin.system.service.SysDictDataService;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 字典数据表 服务实现类
 *
 * @author morethank
 * @since 2022/12/17 17:23
 */
@AllArgsConstructor
@Service
public class SysDictDataServiceImpl extends ServiceImpl<SysDictDataMapper, SysDictData> implements SysDictDataService {

    private final SysDictDataMapper sysDictDataMapper;
    private final DictService dictService;

    @Override
    public IPage<SysDictData> selectListPage(Page<SysDictData> page, LambdaQueryWrapper<SysDictData> query) {
        return sysDictDataMapper.selectPage(page, query);
    }

    @Override
    public void deleteDictDataByIds(Long[] dictCodes) {
        for (Long dictCode : dictCodes) {
            SysDictData data = getById(dictCode);
            sysDictDataMapper.deleteById(dictCode);
            List<SysDictData> dictDatas = sysDictDataMapper.selectDictDataByType(data.getDictType());
            dictService.setDictCache(data.getDictType(), dictDatas);
        }
    }
}
