package cn.morethank.open.admin.system.service.impl;

import cn.morethank.open.admin.system.domain.ApiProject;
import cn.morethank.open.admin.system.mapper.ApiProjectMapper;
import cn.morethank.open.admin.system.service.ApiProjectService;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collections;

/**
 * API项目 服务实现类
 *
 * @author morethank
 * @since 2023-02-16 21:35:25
 */
@AllArgsConstructor
@Service
public class ApiProjectServiceImpl extends ServiceImpl<ApiProjectMapper, ApiProject> implements ApiProjectService {

    private final ApiProjectMapper apiProjectMapper;

    @Override
    public IPage<ApiProject> selectListPage(Page<ApiProject> page, LambdaQueryWrapper<ApiProject> query) {
        return apiProjectMapper.selectPage(page, query);
    }

    @Override
    public int deleteByIds(Long[] ids) {
        ArrayList<Long> arrayList = new ArrayList<>(ids.length);
		Collections.addAll(arrayList, ids);
        this.removeByIds(arrayList);
        return ids.length;
    }

    @Override
    public boolean checkNameUnique(ApiProject apiProject) {
        LambdaQueryWrapper<ApiProject> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ApiProject::getProjectName, apiProject.getProjectName());
        if(apiProject.getProjectId() != null && apiProject.getProjectId() > 0L) {
            wrapper.ne(ApiProject::getProjectId, apiProject.getProjectId());
        }
        long count = apiProjectMapper.selectCount(wrapper);
        return count > 0;
    }

    @Override
    public Long getProjectIdByApikey(String apikey) {
        Long projectId = apiProjectMapper.getProjectIdByApikey(apikey);
        return projectId;
    }
}
