package cn.morethank.open.admin.system.service.impl;

import cn.morethank.open.admin.common.domain.TreeSelect;
import cn.morethank.open.admin.system.domain.ApiInterface;
import cn.morethank.open.admin.system.domain.ApiModule;
import cn.morethank.open.admin.system.mapper.ApiModuleMapper;
import cn.morethank.open.admin.system.service.ApiModuleService;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * API模块 服务实现类
 *
 * @author morethank
 * @since 2023-02-16 21:35:25
 */
@AllArgsConstructor
@Service
public class ApiModuleServiceImpl extends ServiceImpl<ApiModuleMapper, ApiModule> implements ApiModuleService {

    private final ApiModuleMapper apiModuleMapper;

    @Override
    public IPage<ApiModule> selectListPage(Page<ApiModule> page, LambdaQueryWrapper<ApiModule> query) {
        return apiModuleMapper.selectPage(page, query);
    }

    @Override
    public int deleteByIds(Long[] ids) {
        ArrayList<Long> arrayList = new ArrayList<>(ids.length);
		Collections.addAll(arrayList, ids);
        this.removeByIds(arrayList);
        return ids.length;
    }

    @Override
    public boolean checkNameUnique(ApiModule apiModule) {
        LambdaQueryWrapper<ApiModule> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ApiModule::getModuleName, apiModule.getModuleName());
        if(apiModule.getModuleId() != null && apiModule.getModuleId() > 0L) {
            wrapper.ne(ApiModule::getModuleId, apiModule.getModuleId());
        }
        long count = apiModuleMapper.selectCount(wrapper);
        return count > 0;
    }

    @Override
    public List<TreeSelect> selectModuleTreeList(Long projectId) {
        List<ApiModule> modules = selectModuleList(projectId);
        return buildModuleTreeSelect(modules);
    }

    @Override
    public Long getModuleId(ApiInterface apiInterface) {
        Long moduleId = apiModuleMapper.getModuleId(apiInterface);
        if(moduleId == null) {
            ApiModule module = new ApiModule();
            module.setModuleName(apiInterface.getModule().getModuleName());
            module.setProjectId(apiInterface.getProjectId());
            module.setOrderNum(1);
            apiModuleMapper.insert(module);
            moduleId = module.getModuleId();
        }
        return moduleId;
    }

    private List<ApiModule> selectModuleList(Long projectId) {
        LambdaQueryWrapper<ApiModule> query = new LambdaQueryWrapper<>();
        query.eq(ApiModule::getProjectId, projectId);
        query.orderByAsc(ApiModule::getOrderNum, ApiModule::getModuleName);
        List<ApiModule> list = list(query);
        return list;
    }

    /**
     * 构建前端所需要下拉树结构
     *
     * @param apiModules api模块列表
     * @return 下拉树结构列表
     */
    public List<TreeSelect> buildModuleTreeSelect(List<ApiModule> apiModules) {
        return apiModules.stream().map(TreeSelect::new).collect(Collectors.toList());
    }

}
