package cn.morethank.open.admin.system.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import cn.morethank.open.admin.system.domain.ApiInterface;
import cn.morethank.open.admin.system.mapper.ApiInterfaceMapper;
import cn.morethank.open.admin.system.service.ApiInterfaceService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;
import lombok.AllArgsConstructor;

import java.util.ArrayList;
import java.util.Collections;

/**
 * api接口表 服务实现类
 *
 * @author morethank
 * @since 2023-02-20 09:19:22
 */
@AllArgsConstructor
@Service
public class ApiInterfaceServiceImpl extends ServiceImpl<ApiInterfaceMapper, ApiInterface> implements ApiInterfaceService {

    private final ApiInterfaceMapper apiInterfaceMapper;

    @Override
    public IPage<ApiInterface> selectListPage(Page<ApiInterface> page, ApiInterface apiInterface) {
        return apiInterfaceMapper.selectListPage(page, apiInterface);
    }

    @Override
    public int deleteByIds(Long[] ids) {
        ArrayList<Long> arrayList = new ArrayList<>(ids.length);
		Collections.addAll(arrayList, ids);
        this.removeByIds(arrayList);
        return ids.length;
    }

    @Override
    public ApiInterface getDetailById(Long id) {
        return apiInterfaceMapper.getDetailById(id);
    }
}
