package cn.morethank.open.admin.system.service;

import cn.morethank.open.admin.system.domain.SysUser;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
 * 用户信息表 服务类
 *
 * @author morethank
 * @since 2022/12/17 17:23
 */
public interface SysUserService extends IService<SysUser> {

    SysUser getByUsername(String username);

    IPage<SysUser> selectListPage(Page<SysUser> of, SysUser sysUser);

    String getUserAuthorityInfo(Long userId);

    SysUser selectUserById(Long id);

    void checkUserAllowed(SysUser sysUser);

    int deleteUserByIds(Long[] userIds);

    boolean checkUserNameUnique(String userName);

    boolean checkPhoneUnique(SysUser sysUser);

    boolean checkEmailUnique(SysUser sysUser);

    int insertUser(SysUser sysUser);

    int updateUser(SysUser sysUser);

    int resetPwd(SysUser sysUser);

    String selectUserRoleGroup(String userName);

    String selectUserPostGroup(String userName);

    void insertUserAuth(Long userId, Long[] roleIds);

    IPage<SysUser> selectAllocatedList(Page<SysUser> page, SysUser sysUser);

    IPage<SysUser> selectUnallocatedList(Page<SysUser> page, SysUser sysUser);

    List<SysUser> selectUserList(SysUser sysUser);

    boolean updateUserAvatar(String username, String avatar);
}
