package cn.morethank.open.admin.system.service;

import cn.morethank.open.admin.system.domain.SysRole;
import cn.morethank.open.admin.system.domain.SysUserRole;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.Collection;
import java.util.List;

/**
 * 角色信息表 服务类
 *
 * @author morethank
 * @since 2022/12/17 17:23
 */
public interface SysRoleService extends IService<SysRole> {

    IPage<SysRole> selectListPage(Page<SysRole> page, LambdaQueryWrapper<SysRole> query);

    Collection<String> selectRolePermissionByUserId(Long userId);

    int updateRoleStatus(SysRole role);

    void checkRoleAllowed(SysRole role);

    boolean checkRoleNameUnique(SysRole role);

    boolean checkRoleKeyUnique(SysRole role);

    int insertRole(SysRole role);

    int deleteRoleByIds(Long[] roleIds);

    int countUserRoleByRoleId(Long roleId);

    int updateRole(SysRole role);

    List<SysRole> selectRolesByUserId(Long userId);

    List<SysRole> selectRoleList(SysRole role);

    int insertAuthUsers(Long roleId, Long[] userIds);

    int deleteAuthUser(SysUserRole userRole);

    int deleteAuthUsers(Long roleId, Long[] userIds);
}
