package cn.morethank.open.admin.system.service;

import cn.morethank.open.admin.system.domain.SysPost;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
 * 岗位信息表 服务类
 *
 * @author morethank
 * @since 2022/12/17 17:23
 */
public interface SysPostService extends IService<SysPost> {

    IPage<SysPost> selectListPage(Page<SysPost> page, LambdaQueryWrapper<SysPost> query);

    int deletePostByIds(Long[] postIds);

    int countUserPostById(Long postId);

    boolean checkPostNameUnique(SysPost post);

    boolean checkPostCodeUnique(SysPost post);

    List<Long> selectPostListByUserId(Long userId);
}
