package cn.morethank.open.admin.system.service;

import cn.morethank.open.admin.common.domain.TreeSelect;
import cn.morethank.open.admin.common.domain.UserObject;
import cn.morethank.open.admin.system.domain.SysMenu;
import cn.morethank.open.admin.system.vo.RouterVo;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;
import java.util.Set;

/**
 * 菜单权限表 服务类
 *
 * @author morethank
 * @since 2022/12/17 17:23
 */
public interface SysMenuService extends IService<SysMenu> {

    IPage<SysMenu> selectListPage(Page<SysMenu> page, LambdaQueryWrapper<SysMenu> query);

    Set<String> selectMenuPermsByRoleId(Long roleId);

    Set<String> selectMenuPermsByUserId(Long userId);

    List<SysMenu> selectMenuTreeByUserId(Long userId);

    List<RouterVo> buildMenus(List<SysMenu> menus);

    List<SysMenu> selectMenuList(UserObject user);

    List<SysMenu> selectMenuList(SysMenu menu, UserObject user);

    List<TreeSelect> buildMenuTreeSelect(List<SysMenu> menus);

    List<SysMenu> buildMenuTree(List<SysMenu> menus);

    List<Long> selectMenuListByRoleId(Long roleId);

    List<SysMenu> selectMenuListByUserId(SysMenu sysMenu);

    boolean checkMenuNameUnique(SysMenu menu);

    boolean hasChildByMenuId(Long menuId);

    boolean checkMenuExistRole(Long menuId);
}
