package cn.morethank.open.admin.system.service;

import cn.morethank.open.admin.system.domain.SysDictData;
import cn.morethank.open.admin.system.domain.SysDictType;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
 * 字典类型表 服务类
 *
 * @author morethank
 * @since 2022/12/17 17:23
 */
public interface SysDictTypeService extends IService<SysDictType> {

    IPage<SysDictType> selectListPage(Page<SysDictType> page, LambdaQueryWrapper<SysDictType> query);

    List<SysDictData> selectDictDataByType(String dictType);

    int deleteDictTypeByIds(Long[] dictIds);

    boolean checkDictTypeUnique(SysDictType dict);

    void resetDictCache();
}
