package cn.morethank.open.admin.system.service;

import cn.morethank.open.admin.system.domain.SysConfig;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 参数配置表 服务类
 *
 * @author morethank
 * @since 2022/12/17 17:23
 */
public interface SysConfigService extends IService<SysConfig> {

    IPage<SysConfig> selectListPage(Page<SysConfig> page, LambdaQueryWrapper<SysConfig> query);

    int deleteConfigByIds(Long[] configIds);

    void resetConfigCache();

    void clearConfigCache();

    void loadingConfigCache();

    boolean checkConfigKeyUnique(SysConfig config);

    Object selectConfigByKey(String configKey);
}
