package cn.morethank.open.admin.system.service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import cn.morethank.open.admin.system.domain.ApiProject;
import com.baomidou.mybatisplus.extension.service.IService;

/**
 * API项目 服务类
 *
 * @author morethank
 * @since 2023-02-16 21:35:25
 */
public interface ApiProjectService extends IService<ApiProject> {

    IPage<ApiProject> selectListPage(Page<ApiProject> page, LambdaQueryWrapper<ApiProject> query);

    int deleteByIds(Long[] ids);

    boolean checkNameUnique(ApiProject apiProject);

    Long getProjectIdByApikey(String apikey);
}
