package cn.morethank.open.admin.system.service;

import cn.morethank.open.admin.common.domain.TreeSelect;
import cn.morethank.open.admin.system.domain.ApiInterface;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import cn.morethank.open.admin.system.domain.ApiModule;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
 * API模块 服务类
 *
 * @author morethank
 * @since 2023-02-16 21:35:25
 */
public interface ApiModuleService extends IService<ApiModule> {

    IPage<ApiModule> selectListPage(Page<ApiModule> page, LambdaQueryWrapper<ApiModule> query);

    int deleteByIds(Long[] ids);

    boolean checkNameUnique(ApiModule apiModule);

    List<TreeSelect> selectModuleTreeList(Long projectId);

    Long getModuleId(ApiInterface apiInterface);
}
