package cn.morethank.open.admin.system.mapper;

import cn.morethank.open.admin.system.domain.SysUser;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 用户信息表 Mapper 接口
 * </p>
 *
 * @author morethank
 * @since 2022/12/17 17:23
 */
public interface SysUserMapper extends BaseMapper<SysUser> {

    List<Long> getNavMenuIds(Long userId);

    int selectNormalChildrenDeptById(Long deptId);

    IPage<SysUser> selectListPage(Page<SysUser> page, @Param("sysUser") SysUser sysUser);

    SysUser selectUserById(Long userId);

    SysUser selectUserByUserName(String username);

    IPage<SysUser> selectAllocatedList(Page<SysUser> page, @Param("sysUser") SysUser sysUser);

    IPage<SysUser> selectUnallocatedList(Page<SysUser> page, @Param("sysUser") SysUser sysUser);

    List<SysUser> selectUserList(@Param("sysUser") SysUser sysUser);

    int updateUserAvatar(@Param("userName") String userName, @Param("avatar") String avatar);
}
