package cn.morethank.open.admin.system.domain;

import cn.morethank.open.admin.common.annotation.ExcelFormat;
import cn.morethank.open.admin.common.annotation.ExcelStringDictConverter;
import cn.morethank.open.admin.common.domain.BaseEntity;
import cn.morethank.open.admin.common.domain.UserObject;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 
 * 用户信息表
 *
 * @author morethank
 * @since 2022/12/17 17:23
 */
@ExcelIgnoreUnannotated
@Getter
@Setter
@TableName("sys_user")
public class SysUser extends BaseEntity implements UserObject, Serializable {

    private static final long serialVersionUID = 1L;

    public SysUser() {
    }

    public SysUser(Long userId) {
        this.userId = userId;
    }

    /**
     * 用户ID
     */
    @TableId(value = "user_id", type = IdType.AUTO)
    private Long userId;

    /**
     * 部门ID
     */
    @TableField("dept_id")
    private Long deptId;

    /**
     * 用户账号
     */
    @ExcelProperty("用户账号")
    @NotBlank(message = "用户账号不能为空")
    @Size(min = 0, max = 30, message = "用户账号长度不能超过30个字符")
    @TableField("user_name")
    private String userName;

    /**
     * 用户昵称
     */
    @ExcelProperty("用户昵称")
    @Size(min = 0, max = 30, message = "用户昵称长度不能超过30个字符")
    @TableField("nick_name")
    private String nickName;

    /**
     * 用户类型（00系统用户）
     */
    @TableField("user_type")
    private String userType;

    /**
     * 用户邮箱
     */
    @ExcelProperty("用户邮箱")
    @Email(message = "邮箱格式不正确")
    @Size(min = 0, max = 50, message = "邮箱长度不能超过50个字符")
    @TableField("email")
    private String email;

    /**
     * 手机号码
     */
    @ExcelProperty("手机号码")
    @Size(min = 0, max = 11, message = "手机号码长度不能超过11个字符")
    @TableField("phone_number")
    private String phoneNumber;

    /**
     * 用户性别（0男 1女 2未知）
     */
    @ExcelProperty(value="用户性别", converter = ExcelStringDictConverter.class)
    @ExcelFormat(expression="0=男,1=女,2=未知")
    @TableField("sex")
    private String sex;

    /**
     * 头像地址
     */
    @TableField("avatar")
    private String avatar;

    /**
     * 密码
     */
    @TableField("password")
    private String password;

    /**
     * 帐号状态（0正常 1停用）
     */
    @TableField("status")
    private String status;

    /**
     * 删除标志（0代表存在 2代表删除）
     */
    @TableField("del_flag")
    private String delFlag;

    /**
     * 最后登录IP
     */
    @TableField("login_ip")
    private String loginIp;

    /**
     * 最后登录时间
     */
    @TableField("login_date")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime loginDate;

    /**
     * 备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 角色对象
     */
    @TableField(exist = false)
    private List<SysRole> roles;

    /** 角色组 */
    @TableField(exist = false)
    private Long[] roleIds;

    /** 岗位组 */
    @TableField(exist = false)
    private Long[] postIds;

    /** 部门对象 */
    @TableField(exist = false)
    private SysDept dept;

    /** 生成公钥时生成的UUID */
    @TableField(exist = false)
    private String uuid;

    /** 重置密码时的加密公钥 */
    @TableField(exist = false)
    private String publicKey;

    /** 角色ID */
    @TableField(exist = false)
    private Long roleId;

    public boolean isAdmin() {
        return isAdmin(this.userId);
    }

    public static boolean isAdmin(Long userId) {
        return userId != null && 1L == userId;
    }

}
