package cn.morethank.open.admin.system.domain;

import cn.morethank.open.admin.common.annotation.ExcelFormat;
import cn.morethank.open.admin.common.annotation.ExcelStringDictConverter;
import cn.morethank.open.admin.common.domain.BaseEntity;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Set;

/**
 * 
 * 角色信息表
 *
 * @author morethank
 * @since 2022/12/17 17:23
 */
@ExcelIgnoreUnannotated
@Getter
@Setter
@TableName("sys_role")
public class SysRole extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    public SysRole() {
    }

    public SysRole(Long roleId) {
        this.roleId = roleId;
    }

    /**
     * 角色ID
     */
    @TableId(value = "role_id", type = IdType.AUTO)
    private Long roleId;

    /**
     * 角色名称
     */
    @ExcelProperty("角色名称")
    @NotBlank(message = "角色名称不能为空")
    @Size(min = 1, max = 30, message = "角色名称长度不能超过30个字符")
    @TableField("role_name")
    private String roleName;

    /**
     * 角色权限字符串
     */
    @ExcelProperty("角色权限字符串")
    @NotBlank(message = "权限字符不能为空")
    @Size(min = 1, max = 100, message = "权限字符长度不能超过100个字符")
    @TableField("role_key")
    private String roleKey;

    /**
     * 显示顺序
     */
    @TableField("role_sort")
    @NotNull(message = "显示顺序不能为空")
    private Integer roleSort;

    /**
     * 菜单树选择项是否关联显示（ 0：父子不互相关联显示 1：父子互相关联显示）
     */
    @TableField("menu_check_strictly")
    private boolean menuCheckStrictly;

    /**
     * 部门树选择项是否关联显示（0：父子不互相关联显示 1：父子互相关联显示 ）
     */
    @TableField("dept_check_strictly")
    private boolean deptCheckStrictly;

    /**
     * 角色状态（0正常 1停用）
     */
    @ExcelProperty(value="角色状态", converter = ExcelStringDictConverter.class)
    @ExcelFormat(expression="0=正常,1=停用")
    @TableField("status")
    private String status;

    /**
     * 删除标志（0代表存在 2代表删除）
     */
    @TableField("del_flag")
    private String delFlag;

    /**
     * 备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 角色菜单权限
     */
    @TableField(exist = false)
    private Set<String> permissions;


    /**
     * 用户是否存在此角色标识 默认不存在
     */
    @TableField(exist = false)
    private boolean flag = false;

    /**
     * 菜单组
     */
    @TableField(exist = false)
    private Long[] menuIds;

    /**
     * 部门组（数据权限）
     */
    @TableField(exist = false)
    private Long[] deptIds;

    public boolean isAdmin() {
        return isAdmin(this.roleId);
    }

    private boolean isAdmin(Long roleId) {
        return roleId != null && 1L == roleId;
    }
}
