package cn.morethank.open.admin.system.domain;

import cn.morethank.open.admin.common.annotation.ExcelFormat;
import cn.morethank.open.admin.common.annotation.ExcelStringDictConverter;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Map;

/**
 * 
 * 系统访问记录
 *
 * @author morethank
 * @since 2022/12/17 17:23
 */
@ExcelIgnoreUnannotated
@Getter
@Setter
@TableName("sys_login_log")
public class SysLoginLog implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 访问ID
     */
    @TableId(value = "info_id", type = IdType.AUTO)
    private Long infoId;

    /**
     * 用户账号
     */
    @ExcelProperty("用户账号")
    @TableField("user_name")
    private String userName;

    /**
     * 登录IP地址
     */
    @ExcelProperty("登录IP地址")
    @TableField("ipaddr")
    private String ipaddr;

    /**
     * 登录地点
     */
    @ExcelProperty("登录地点")
    @TableField("login_location")
    private String loginLocation;

    /**
     * 浏览器类型
     */
    @ExcelProperty("浏览器类型")
    @TableField("browser")
    private String browser;

    /**
     * 操作系统
     */
    @ExcelProperty("操作系统")
    @TableField("os")
    private String os;

    /**
     * 登录状态（0成功 1失败）
     */
    @ExcelProperty(value="登录状态", converter = ExcelStringDictConverter.class)
    @ExcelFormat(expression="0=成功,1=失败")
    @TableField("status")
    private String status;

    /**
     * 提示消息
     */
    @ExcelProperty("提示消息")
    @TableField("msg")
    private String msg;

    /**
     * 访问时间
     */
    @ExcelProperty("访问时间")
    @TableField("login_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime loginTime;

    /**
     * 请求参数
     */
    @TableField(exist = false)
    private Map<String, Object> params;

}
