package cn.morethank.open.admin.system.domain;

import cn.morethank.open.admin.common.domain.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * 代码生成业务表
 *
 * @author morethank
 * @since 2023-01-08 00:30:18
 */
@Getter
@Setter
@TableName("sys_gen_table")
public class SysGenTable extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 编号
     */
    @TableId(value = "table_id", type = IdType.AUTO)
    private Long tableId;

    /**
     * 表名称
     */
    @TableField("table_name")
    private String tableName;

    /**
     * 表描述
     */
    @TableField("table_comment")
    private String tableComment;

    /**
     * 关联子表的表名
     */
    @TableField("sub_table_name")
    private String subTableName;

    /**
     * 子表关联的外键名
     */
    @TableField("sub_table_fk_name")
    private String subTableFkName;

    /**
     * 实体类名称
     */
    @TableField("class_name")
    private String className;

    /**
     * 使用的模板（crud单表操作 tree树表操作）
     */
    @TableField("tpl_category")
    private String tplCategory;

    /**
     * 生成包路径
     */
    @TableField("package_name")
    private String packageName;

    /**
     * 生成模块名
     */
    @TableField("module_name")
    private String moduleName;

    /**
     * 生成业务名
     */
    @TableField("business_name")
    private String businessName;

    /**
     * 生成功能名
     */
    @TableField("function_name")
    private String functionName;

    /**
     * 生成功能作者
     */
    @TableField("function_author")
    private String functionAuthor;

    /**
     * 其它生成选项
     */
    @TableField("options")
    private String options;

    /**
     * 备注
     */
    @TableField("remark")
    private String remark;

    /** 主键信息 */
    @TableField(exist = false)
    private SysGenColumn pkColumn;

    /** 子表信息 */
    @TableField(exist = false)
    private SysGenTable subTable;

    /**
     * 列
     */
    @TableField(exist = false)
    private List<SysGenColumn> columns;

    /** 树编码字段 */
    @TableField(exist = false)
    private String treeCode;

    /** 树父编码字段 */
    @TableField(exist = false)
    private String treeParentCode;

    /** 树名称字段 */
    @TableField(exist = false)
    private String treeName;

    /** 上级菜单ID字段 */
    @TableField(exist = false)
    private String parentMenuId;

    /** 上级菜单名称字段 */
    @TableField(exist = false)
    private String parentMenuName;
}
