package cn.morethank.open.admin.system.domain;

import cn.morethank.open.admin.common.annotation.ExcelFormat;
import cn.morethank.open.admin.common.annotation.ExcelStringDictConverter;
import cn.morethank.open.admin.common.domain.BaseEntity;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 
 * 字典类型表
 *
 * @author morethank
 * @since 2022/12/17 17:23
 */
@ExcelIgnoreUnannotated
@Getter
@Setter
@TableName("sys_dict_type")
public class SysDictType extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 字典主键
     */
    @TableId(value = "dict_id", type = IdType.AUTO)
    private Long dictId;

    /**
     * 字典名称
     */
    @ExcelProperty("字典名称")
    @TableField("dict_name")
    private String dictName;

    /**
     * 字典类型
     */
    @ExcelProperty("字典名称")
    @TableField("dict_type")
    private String dictType;

    /**
     * 状态（0正常 1停用）
     */
    @ExcelProperty(value="状态", converter = ExcelStringDictConverter.class)
    @ExcelFormat(expression="0=正常,1=停用")
    @TableField("status")
    private String status;

    /**
     * 备注
     */
    @ExcelProperty("备注")
    @TableField("remark")
    private String remark;

}
