package cn.morethank.open.admin.system.domain;

import cn.morethank.open.admin.common.domain.BaseEntity;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * 
 * 参数配置表
 *
 * @author morethank
 * @since 2022/12/17 17:23
 */
@ExcelIgnoreUnannotated
@Getter
@Setter
@TableName("sys_config")
public class SysConfig extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 参数主键
     */
    @ExcelProperty("参数主键")
    @TableId(value = "config_id", type = IdType.AUTO)
    private Integer configId;

    /**
     * 参数名称
     */
    @ExcelProperty("参数名称")
    @NotBlank(message = "参数名称不能为空")
    @Size(min = 1, max = 100, message = "参数名称不能超过100个字符")
    @TableField("config_name")
    private String configName;

    /**
     * 参数键名
     */
    @ExcelProperty("参数键名")
    @NotBlank(message = "参数键名长度不能为空")
    @Size(min = 0, max = 100, message = "参数键名长度不能超过100个字符")
    @TableField("config_key")
    private String configKey;

    /**
     * 参数键值
     */
    @ExcelProperty("参数键值")
    @NotBlank(message = "参数键值不能为空")
    @Size(min = 1, max = 500, message = "参数键值长度不能超过500个字符")
    @TableField("config_value")
    private String configValue;

    /**
     * 系统内置（Y是 N否）
     */
    @ExcelProperty("系统内置")
    @TableField("config_type")
    private String configType;

    /**
     * 备注
     */
    @ExcelProperty("备注")
    @TableField("remark")
    private String remark;

}
