package cn.morethank.open.admin.system.domain;

import cn.morethank.open.admin.common.domain.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 
 * API项目
 *
 * @author morethank
 * @since 2023-02-18 20:07:42
 */
@Getter
@Setter
@TableName("sys_api_project")
public class ApiProject extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 项目id
     */
    @TableId(value = "project_id", type = IdType.AUTO)
    private Long projectId;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 项目路径
     */
    @TableField("project_url")
    private String projectUrl;

    /**
     * api密钥
     */
    @TableField("apikey")
    private String apikey;

    /**
     * 状态（0正常 1停用）
     */
    @TableField("status")
    private String status;

    /**
     * 备注
     */
    @TableField("remark")
    private String remark;

}
