package cn.morethank.open.admin.system.domain;

import cn.morethank.open.admin.common.domain.BaseEntity;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 
 * api接口表
 *
 * @author morethank
 * @since 2023-02-20 10:23:57
 */
@Getter
@Setter
@TableName("sys_api_interface")
public class ApiInterface extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "interface_id", type = IdType.AUTO)
    private Long interfaceId;

    /**
     * 项目id
     */
    @TableField("project_id")
    private Long projectId;

    /**
     * 模块id
     */
    @TableField("module_id")
    private Long moduleId;

    /**
     * 接口名称
     */
    @TableField("interface_name")
    private String interfaceName;

    /**
     * 请求方式GET/POST
     */
    @TableField("method")
    private String method;

    /**
     * 接口路径
     */
    @TableField("path")
    private String path;

    /**
     * 接口状态 0未完成 1已完成
     */
    @TableField("status")
    private String status;

    /**
     * 请求头
     */
    @TableField("request_header")
    private String requestHeader;

    /**
     * 请求参数
     */
    @TableField("request_parameter")
    private String requestParameter;

    /**
     * 请求体
     */
    @TableField("request_body")
    private String requestBody;

    /**
     * 返回数据
     */
    @TableField("response_data")
    private String responseData;

    /**
     * 备注
     */
    @TableField("remark")
    private String remark;


    /** 部门对象 */
    @TableField(exist = false)
    private ApiModule module;

    /**
     * 请求参数 JSONArray
     */
    @TableField(exist = false)
    private JSONArray requestParamArray;

    /**
     * 请求体 JSONArray
     */
    @TableField(exist = false)
    private JSONArray requestBodyArray;

    @TableField(exist = false)
    private JSONObject responseDataJson;

    /**
     * 项目的apikey
     * 用于自动生成接口时的key
     */
    @TableField(exist = false)
    private String apikey;

}
