package cn.morethank.open.admin.system.controller;

import cn.morethank.open.admin.common.constant.RedisKeyConstant;
import cn.morethank.open.admin.common.domain.Result;
import cn.morethank.open.admin.common.domain.LoginAccount;
import cn.morethank.open.admin.common.service.RedisService;
import cn.morethank.open.admin.common.util.StringUtils;
import cn.morethank.open.admin.system.domain.SysUserOnline;
import cn.morethank.open.admin.system.service.SysUserOnlineService;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.AllArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/**
 * 在线用户
 * @author morethank
 * @since 2022/12/17 17:23
 */
@AllArgsConstructor
@RestController
@RequestMapping("/system/online")
public class SysUserOnlineController {

    private final SysUserOnlineService sysUserOnlineService;
    private final RedisService redisService;

    @PreAuthorize("@auth.hasAuthority('system:online:list')")
    @GetMapping("/list")
    public Result list(String ipaddr, String userName) {
        Collection<String> keys = redisService.keys(RedisKeyConstant.LOGIN_TOKEN_KEY + "*");
        List<SysUserOnline> userOnlineList = new ArrayList<>();
        for (String key : keys) {
            LoginAccount user = (LoginAccount) redisService.getByKey(key);
            if (StringUtils.isNotEmpty(ipaddr) && StringUtils.isNotEmpty(userName)) {
                if (user.getIpaddr().contains(ipaddr) && user.getUsername().contains(userName)) {
                    SysUserOnline userOnline = sysUserOnlineService.selectOnlineByInfo(ipaddr, userName, user);
                    if(userOnline != null) {
                        userOnlineList.add(userOnline);
                    }
                }
            } else if (StringUtils.isNotEmpty(ipaddr)) {
                if (user.getIpaddr().contains(ipaddr)) {
                    SysUserOnline userOnline = sysUserOnlineService.selectOnlineByIpaddr(ipaddr, user);
                    if(userOnline != null) {
                        userOnlineList.add(userOnline);
                    }
                }
            } else if (StringUtils.isNotEmpty(userName) && StringUtils.isNotNull(user.getUser())) {
                if (user.getUsername().contains(userName)) {
                    SysUserOnline userOnline = sysUserOnlineService.selectOnlineByUserName(userName, user);
                    if(userOnline != null) {
                        userOnlineList.add(userOnline);
                    }
                }
            } else {
                SysUserOnline userOnline = sysUserOnlineService.loginUserToUserOnline(user);
                if(userOnline != null) {
                    userOnlineList.add(userOnline);
                }
            }
        }
        Collections.reverse(userOnlineList);

        // 封装成分页格式
        Page<SysUserOnline> pageList = new Page<>(0, 0, userOnlineList.size());
        pageList.setRecords(userOnlineList);
        return Result.success(pageList);
    }

    /**
     * 强退用户
     */
    @PreAuthorize("@auth.hasAuthority('system:online:forceLogout')")
    @DeleteMapping("/{tokenId}")
    public Result forceLogout(@PathVariable String tokenId) {
        redisService.del(RedisKeyConstant.LOGIN_TOKEN_KEY + tokenId);
        return Result.success();
    }
}
