package cn.morethank.open.admin.system.controller;

import cn.morethank.open.admin.common.domain.Result;
import cn.morethank.open.admin.system.domain.server.Server;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 服务监控
 * @author morethank
 * @since 2022/12/17 17:23
 */
@RestController
@RequestMapping("/system/server")
public class ServerController {

    /**
     * 服务详情
     * @return
     * @throws Exception
     */
    @PreAuthorize("@auth.hasAuthority('system:server:list')")
    @GetMapping()
    public Result<Server> getInfo() throws Exception {
        Server server = new Server();
        server.inspect();
        return Result.success(server);
    }
}
