package cn.morethank.open.admin.common.util;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author morethank
 * @since 2022/12/17 17:23
 */
@Slf4j
public class RequestUtil {

    public static HttpServletRequest getRequest() {
        return ((ServletRequestAttributes) (RequestContextHolder.currentRequestAttributes())).getRequest();
    }

    public static String getBodyString(ServletRequest request) {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = null;
        try (InputStream inputStream = request.getInputStream()) {
            reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            String line = "";
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        } catch (IOException e) {
            log.warn("getBodyString出现问题！", e);
        } finally {
            if (reader != null) {
                try {
                    reader.close();
                } catch (IOException e) {
                    log.error(ExceptionUtils.getMessage(e));
                }
            }
        }
        String url = ((HttpServletRequest)request).getRequestURI();
        if("/system/api/interface".equals(url) || "/system/api/interface/sync".equals(url)) {
            return sb.toString();
        }
        return xssFilter(sb.toString());
    }

    public static boolean containHtml(String str) {
        // 如果包含html标签则返回空字符串
        String HTML_PATTERN = ".*?<(\\S*?)[^>]*>.*?|<.*? />.*?";
        Pattern pattern = Pattern.compile(HTML_PATTERN);
        Matcher matcher = pattern.matcher(str);
        return matcher.matches();
    }

    /**
     * 过滤文本的内容, 将容易引起xss漏洞的半角字符直接替换成全角字符
     */
    public static String xssFilter(String str) {
        if (isEmpty(str)) {
            return str;
        }

        if (!containHtml(str)) {
            return str;
        }

        StringBuilder sb = new StringBuilder(str.length() + 16);
        for (int i = 0; i < str.length(); i++) {
            char c = str.charAt(i);
            switch (c) {
                case '>':
                    // 全角大于号
                    sb.append('＞');
                    break;
                case '<':
                    // 全角小于号
                    sb.append('＜');
                    break;
/*                case '\'':
                    // 全角单引号
                    sb.append('‘');
                    break;
                case '\"':
                    // 全角双引号
                    sb.append('“');
                    break;*/
                case '&':
                    // 全角
                    sb.append('＆');
                    break;
                case '\\':
                    // 全角斜线
                    sb.append('＼');
                    break;
                case '#':
                    // 全角井号
                    sb.append('＃');
                    break;
                case '(':
                    sb.append('（');
                    break;
                case ')':
                    sb.append('）');
                    break;
                default:
                    sb.append(c);
                    break;
            }
        }
        return sb.toString();
    }

    public static boolean isEmpty(String txt) {
        return txt == null || txt.trim().length() == 0;
    }

}
