package cn.morethank.open.admin.common.util;

import cn.hutool.core.util.StrUtil;
import cn.morethank.open.admin.common.constant.GlobalConstant;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.springframework.util.CollectionUtils;

import java.util.Map;

/**
 * @author morethank
 * @since 2022/12/17 17:23
 */
public class QueryWrapperUtil {

    public static void createTimeCondition(LambdaQueryWrapper query, Map<String, Object> params) {
        if (!CollectionUtils.isEmpty(params)) {
            String time = (String) params.get(GlobalConstant.BEGIN_TIME);
            if (StrUtil.isNotEmpty(time)) {
                query.apply(GlobalConstant.DATE_FORMAT_GE + time + GlobalConstant.SINGLE_QUOTATION);
            }
            String endTime = (String) params.get(GlobalConstant.END_TIME);
            if (StrUtil.isNotEmpty(endTime)) {
                query.apply(GlobalConstant.DATE_FORMAT_LE + endTime + GlobalConstant.SINGLE_QUOTATION);
            }
        }
    }

    public static void loginTimeCondition(LambdaQueryWrapper query, Map<String, Object> params) {
        if (!CollectionUtils.isEmpty(params)) {
            String beginTime = (String) params.get(GlobalConstant.BEGIN_TIME);
            if (StrUtil.isNotEmpty(beginTime)) {
                query.apply(GlobalConstant.LOGIN_FORMAT_GE + beginTime + GlobalConstant.SINGLE_QUOTATION);
            }
            String endTime = (String) params.get(GlobalConstant.END_TIME);
            if (StrUtil.isNotEmpty(endTime)) {
                query.apply(GlobalConstant.LOGIN_FORMAT_LE + endTime + GlobalConstant.SINGLE_QUOTATION);
            }
        }
    }

}
