package cn.morethank.open.admin.common.util;

import cn.hutool.http.useragent.UserAgent;
import cn.hutool.http.useragent.UserAgentUtil;
import cn.morethank.open.admin.common.constant.GlobalConstant;
import cn.morethank.open.admin.system.domain.SysLoginLog;
import cn.morethank.open.admin.system.domain.SysOperLog;
import cn.morethank.open.admin.system.service.SysLoginLogService;
import cn.morethank.open.admin.system.service.SysOperLogService;
import lombok.extern.slf4j.Slf4j;

import javax.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;
import java.util.concurrent.CompletableFuture;

/**
 * @author morethank
 * @since 2022/12/17 17:23
 */
@Slf4j
public class LogUtil {

    public static void saveLoginLog(final SysLoginLogService sysLoginLogService, final String username,
                                    final String status, final String message, final Object... args) {
        HttpServletRequest request = RequestUtil.getRequest();
        UserAgent ua = UserAgentUtil.parse(request.getHeader(GlobalConstant.USER_AGENT));
        final String ip = IpUtils.getIpAddr(request);
        CompletableFuture.runAsync(() -> {
            String address = IpUtils.getRealAddressByIP(ip);
            String s = getBlock(ip) + address + getBlock(username) + getBlock(status) + getBlock(message);
            // 打印信息到日志
            log.info(s, args);
            // 获取客户端操作系统
            String os = ua.getOs().getName();
            // 获取客户端浏览器
            String browser = ua.getBrowser().getName();
            // 封装对象
            SysLoginLog loginLog = new SysLoginLog();
            loginLog.setUserName(username);
            loginLog.setIpaddr(ip);
            loginLog.setLoginLocation(address);
            loginLog.setBrowser(browser);
            loginLog.setOs(os);
            loginLog.setMsg(message);
            loginLog.setLoginTime(LocalDateTime.now());
            // 日志状态
            if (StringUtils.equalsAny(status, GlobalConstant.LOGIN_SUCCESS, GlobalConstant.LOGOUT, GlobalConstant.REGISTER)) {
                loginLog.setStatus(GlobalConstant.SUCCESS_STATUS);
            } else if (GlobalConstant.LOGIN_FAIL.equals(status)) {
                loginLog.setStatus(GlobalConstant.FAIL_STATUS);
            }
            // 插入数据
            sysLoginLogService.saveLog(loginLog);
//            sysLoginLogService.save(loginLog);
        });
    }

    public static String getBlock(Object msg) {
        if (msg == null) {
            msg = "";
        }
        return "[" + msg + "]";
    }

    public static void saveOperLog(SysOperLogService sysOperLogService, SysOperLog sysOperLog) {
        CompletableFuture.runAsync(()->{
            // 远程查询操作地点
            sysOperLog.setOperLocation(IpUtils.getRealAddressByIP(sysOperLog.getOperIp()));
            sysOperLog.setOperTime(LocalDateTime.now());
            // 插入数据
            sysOperLogService.save(sysOperLog);
        });
    }
}
