package cn.morethank.open.admin.common.service;

import cn.morethank.open.admin.common.constant.GlobalConstant;
import cn.morethank.open.admin.common.domain.UserObject;
import cn.morethank.open.admin.system.domain.SysRole;
import cn.morethank.open.admin.system.service.SysMenuService;
import cn.morethank.open.admin.system.service.SysRoleService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * @author morethank
 * @since 2022/12/17 17:23
 */
@Service
@Slf4j
@AllArgsConstructor
public class SysPermissionService {

    private final SysRoleService sysRoleService;
    private final SysMenuService sysMenuService;

    /**
     * 获取角色数据权限
     *
     * @param user 用户信息
     * @return 角色权限信息
     */
    public Set<String> getRolePermission(UserObject user) {
        Set<String> roles = new HashSet<>();
        // 管理员拥有所有权限
        if (user.isAdmin()) {
            roles.add(GlobalConstant.ADMIN);
        } else {
            roles.addAll(sysRoleService.selectRolePermissionByUserId(user.getUserId()));
        }
        return roles;
    }

    /**
     * 获取菜单数据权限
     *
     * @param user 用户信息
     * @return 菜单权限信息
     */
    public Set<String> getMenuPermission(UserObject user) {
        Set<String> perms = new HashSet<>();
        // 管理员拥有所有权限
        if (user.isAdmin()) {
            perms.add(GlobalConstant.ALL_PERM);
        } else {
            List<SysRole> roles = user.getRoles();
            if (roles != null && !roles.isEmpty() && roles.size() > 1) {
                // 多角色设置permissions属性，以便数据权限匹配权限
                for (SysRole role : roles) {
                    Set<String> rolePerms = sysMenuService.selectMenuPermsByRoleId(role.getRoleId());
                    role.setPermissions(rolePerms);
                    perms.addAll(rolePerms);
                }
            } else {
                perms.addAll(sysMenuService.selectMenuPermsByUserId(user.getUserId()));
            }
        }
        return perms;
    }
}
