package cn.morethank.open.admin.common.security;

import cn.morethank.open.admin.common.domain.LoginAccount;
import cn.morethank.open.admin.system.domain.SysUser;
import cn.morethank.open.admin.common.service.SysPermissionService;
import cn.morethank.open.admin.system.service.SysUserService;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Set;

/**
 * @author morethank
 * @since 2022/12/17 17:23
 */
@Service
public class UserDetailServiceImpl implements UserDetailsService {

	@Resource
    private SysUserService sysUserService;

	@Resource
	private SysPermissionService permissionService;

	@Override
	public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
		SysUser sysUser = sysUserService.getByUsername(username);
		if (sysUser == null) {
			throw new UsernameNotFoundException("用户名或密码不正确");
		}
		Set<String> permissions = permissionService.getMenuPermission(sysUser);
		LoginAccount user = new LoginAccount(sysUser.getUserId(), sysUser.getDeptId(), sysUser, permissions);
		return user;
	}

	/**
	 * 获取用户权限信息（角色、菜单权限）
	 * @param userId
	 * @return 返回权限列表
	 */
	public List<GrantedAuthority> getUserAuthority(Long userId) {
		// 角色(ROLE_admin), 菜单操作权限 sys:user:list, ...
		String authority = sysUserService.getUserAuthorityInfo(userId);
		return AuthorityUtils.commaSeparatedStringToAuthorityList(authority);
	}
}
