package cn.morethank.open.admin.common.security;

import cn.hutool.json.JSONUtil;
import cn.morethank.open.admin.common.constant.GlobalConstant;
import cn.morethank.open.admin.common.domain.ErrorCode;
import cn.morethank.open.admin.common.domain.Result;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.stereotype.Component;

import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * @author morethank
 * @since 2022/12/17 17:23
 */
@Component
public class LoginFailureHandler implements AuthenticationFailureHandler {
    @Override
    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response,
										AuthenticationException exception) throws IOException, ServletException {
        // 以json格式输出登录失败信息
		response.setContentType(GlobalConstant.JSON_CONTENT_TYPE);
		ServletOutputStream outputStream = response.getOutputStream();
		// 验证码错误
		Result result = Result.fail(ErrorCode.USER_CODE_ERROR.code(), GlobalConstant.CODE_ERROR);
//		Result result = Result.fail(ErrorCode.USER_PWD_ERROR.code(), AppConstant.LOGIN_ERROR);
		outputStream.write(JSONUtil.toJsonStr(result).getBytes(GlobalConstant.UTF8));
		outputStream.flush();
		outputStream.close();
    }
}
