package cn.morethank.open.admin.common.security;

import cn.hutool.json.JSONUtil;
import cn.morethank.open.admin.common.constant.GlobalConstant;
import cn.morethank.open.admin.common.domain.Result;
import cn.morethank.open.admin.common.service.JwtService;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * @author morethank
 * @since 2022/12/17 17:23
 */
@Component
public class JwtLogoutSuccessHandler implements LogoutSuccessHandler {

	@Resource
	JwtService jwtService;

	@Override
	public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
		if (authentication != null) {
			new SecurityContextLogoutHandler().logout(request, response, authentication);
		}

		response.setContentType(GlobalConstant.JSON_CONTENT_TYPE);
		ServletOutputStream os = response.getOutputStream();

		response.setHeader(jwtService.getHeader(), GlobalConstant.EMPTY);

		Result result = Result.success();

		os.write(JSONUtil.toJsonStr(result).getBytes(GlobalConstant.UTF8));

		os.flush();
		os.close();
	}
}
