package cn.morethank.open.admin.common.security;

import cn.morethank.open.admin.common.constant.GlobalConstant;
import cn.morethank.open.admin.common.domain.ErrorCode;
import cn.morethank.open.admin.common.exception.ServiceException;
import lombok.SneakyThrows;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;

/**
 * @author morethank
 * @since 2022/12/17 17:23
 */
@Component
public class JwtAuthenticationProvider implements AuthenticationProvider {

    @Resource
    private UserDetailServiceImpl userDetailService;

    @Resource
    @Lazy
    private PasswordEncoder passwordEncoder;

    @SneakyThrows
    @Override
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String username = (String) authentication.getPrincipal();
        String password = (String) authentication.getCredentials();
        // 获取用户信息
        UserDetails userDetails = userDetailService.loadUserByUsername(username);
        if (ObjectUtils.isEmpty(userDetails) || !passwordEncoder.matches(password, userDetails.getPassword())) {
            throw new ServiceException(ErrorCode.USER_PWD_ERROR.code(), GlobalConstant.LOGIN_ERROR);
        }
        return new UsernamePasswordAuthenticationToken(userDetails, password, userDetails.getAuthorities());
    }

    @Override
    public boolean supports(Class<?> authentication) {
        return authentication.equals(UsernamePasswordAuthenticationToken.class);
    }
}
