package cn.morethank.open.admin.common.security;

import cn.hutool.core.util.StrUtil;
import cn.morethank.open.admin.common.domain.LoginAccount;
import cn.morethank.open.admin.common.service.JwtService;
import cn.morethank.open.admin.system.service.SysUserService;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.annotation.Resource;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * @author morethank
 * @since 2022/12/17 17:23
 */
@Component
public class JwtAuthenticationFilter extends OncePerRequestFilter {

	@Resource
    private JwtService jwtService;

	@Resource
	private UserDetailServiceImpl userDetailService;

	@Resource
    private SysUserService sysUserService;

	@Override
	protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response,
                                    FilterChain chain) throws IOException, ServletException {

		String jwt = request.getHeader(jwtService.getHeader());
		if (StrUtil.isBlankOrUndefined(jwt)) {
			chain.doFilter(request, response);
			return;
		}
/*
		Claims claim = jwtService.getClaimByToken(jwt);
		if (claim == null) {
			throw new JwtException("token 异常");
		}
		if (jwtService.isTokenExpired(claim)) {
			throw new JwtException("token已过期");
		}

		String username = claim.getSubject();
		// 获取用户的权限等信息

		SysUser sysUser = sysUserService.getByUsername(username);
		UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken(
                username, null, userDetailService.getUserAuthority(sysUser.getUserId()));

		SecurityContextHolder.getContext().setAuthentication(token);
*/
		LoginAccount loginUser = jwtService.getLoginAccount(request);
		if(loginUser != null && SecurityContextHolder.getContext().getAuthentication() == null) {
            jwtService.verifyToken(loginUser);
            UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken(
					loginUser, null, null);
            authenticationToken.setDetails(new WebAuthenticationDetailsSource().buildDetails(request));
            SecurityContextHolder.getContext().setAuthentication(authenticationToken);
		}
		chain.doFilter(request, response);
	}
}
