package cn.morethank.open.admin.common.security;

import cn.hutool.json.JSONUtil;
import cn.morethank.open.admin.common.constant.GlobalConstant;
import cn.morethank.open.admin.common.domain.ErrorCode;
import cn.morethank.open.admin.common.domain.Result;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.stereotype.Component;

import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * @author morethank
 * @since 2022/12/17 17:23
 */
@Component
public class JwtAccessDeniedHandler implements AccessDeniedHandler {

	@Override
	public void handle(HttpServletRequest request, HttpServletResponse response,
                       AccessDeniedException accessDeniedException) throws IOException, ServletException {
		response.setContentType(GlobalConstant.JSON_CONTENT_TYPE);
		response.setStatus(HttpStatus.FORBIDDEN.value());

		ServletOutputStream os = response.getOutputStream();

		Result result = Result.fail(ErrorCode.FORBIDDEN.code(), accessDeniedException.getMessage());
		os.write(JSONUtil.toJsonStr(result).getBytes(GlobalConstant.UTF8));

		os.flush();
		os.close();
	}
}
