package cn.morethank.open.admin.common.security;

import cn.morethank.open.admin.common.constant.GlobalConstant;
import cn.morethank.open.admin.common.constant.RedisKeyConstant;
import cn.morethank.open.admin.common.exception.CaptchaException;
import cn.morethank.open.admin.common.service.RedisService;
import cn.morethank.open.admin.common.util.RequestUtil;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * @author morethank
 * @since 2022/12/17 17:23
 */
@AllArgsConstructor
@Slf4j
@Component
public class CaptchaFilter extends OncePerRequestFilter {

    private final RedisService redisService;
    private final LoginFailureHandler loginFailureHandler;

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response,
									FilterChain filterChain) throws ServletException, IOException {
		String url = request.getRequestURI();

		if (GlobalConstant.LOGIN_URL.equals(url) && request.getMethod().equals(GlobalConstant.POST)) {
			try{
				// 校验验证码
				validate(request);
			} catch (CaptchaException e) {
				// 交给认证失败处理器
				loginFailureHandler.onAuthenticationFailure(request, response, e);
			}
		}

		filterChain.doFilter(request, response);
	}

	/**
	 * 校验验证码
	 * @param request
	 */
	private void validate(HttpServletRequest request) throws CaptchaException {
		try {
			String body = RequestUtil.getBodyString(request);
			JSONObject json = JSONObject.parseObject(body);
			String code = json.getString(GlobalConstant.CODE);
			String key = json.getString(GlobalConstant.UUID);

			if (StringUtils.isBlank(code) || StringUtils.isBlank(key)) {
				throw new CaptchaException(GlobalConstant.CODE_ERROR);
			}

			Object keyCode = redisService.hget(RedisKeyConstant.CAPTCHA_KEY, key);
			if (keyCode == null || !code.equalsIgnoreCase(keyCode.toString())) {
				throw new CaptchaException(GlobalConstant.CODE_ERROR);
			}

			// 使用一次后删除
			redisService.hdel(RedisKeyConstant.CAPTCHA_KEY, key);
		} catch (Exception e) {
			throw new CaptchaException(e.getMessage());
		}
	}

}
