package cn.morethank.open.admin.common.inject;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

/**
 * 将ServletRequest封装成 AntiInjectRequestWrapper, 解决请求参数防注入获取一次后Controller层就获取不到数据的问题
 * @author morethank
 * @since 2022/12/17 17:23
 */
public class AntiInjectRequestFilter implements Filter {

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /**
     * 将request封装成AntiInjectRequestWrapper
     * @param request
     * @param response
     * @param chain
     * @throws IOException
     * @throws ServletException
     */
    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
            throws IOException, ServletException {
        ServletRequest requestWrapper=null;
        if(request instanceof HttpServletRequest) {
            requestWrapper = new AntiInjectRequestWrapper((HttpServletRequest)request, response);
        }

        if(requestWrapper == null) {
            chain.doFilter(request, response);
        } else {
            chain.doFilter(requestWrapper, response);
        }
    }

    @Override
    public void destroy() {
    }
}
